/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_SIMFILTERBASE_P_H
#define SAILFISH_MDM_SIMFILTERBASE_P_H

#include "mdm-simfilter_p.h"

#include <QObject>
#include <QDBusInterface>

namespace Sailfish {
namespace Mdm {

class SimFilterBasePrivate : public QObject
{
    Q_OBJECT
public:
    SimFilterBasePrivate(SimFilterPrivate::FilterType type, QObject *parent);
    ~SimFilterBasePrivate();

    SimFilter::Action defaultAction();
    bool setDefaultAction(SimFilter::Action action);
    SimFilter::RuleList rules();
    bool setRules(const SimFilter::RuleList &rules);
    bool clearRules();
    bool setRule(const SimFilter::Rule &rule);
    bool removeRule(const QString &imsi);
    bool hasRuleForImsi(const QString &imsi);

public slots:
    void onDefaultActionChanged(int type);
    void onRuleAdded(int type, const Sailfish::Mdm::SimFilterPrivate::RulePrivate &rule);
    void onRuleRemoved(int type, const QString &imsi);
    void onRulesChanged(int type,
                        const Sailfish::Mdm::SimFilterPrivate::RulePrivateList &oldRules,
                        const Sailfish::Mdm::SimFilterPrivate::RulePrivateList &newRules);

signals:
    void defaultActionChanged();
    void ruleAdded(const SimFilter::Rule &rule);
    void ruleRemoved(const QString &imsi);
    void rulesChanged(const SimFilter::RuleList &oldRules, const SimFilter::RuleList &newRules);

public:
    int type;
    QDBusInterface iface;
};

}
}

#endif // SAILFISH_MDM_SIMFILTERBASE_P_H
