/**
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
*/

import QtQuick 2.6
import QtGraphicalEffects 1.0
import Sailfish.Silica 1.0
import Aurora.Lottie 1.0

/*!
    \qmltype LottiePlaceholder
    \inherits ActionsPlaceholder
    \inqmlmodule Aurora.Applications.Internal
    \brief Placeholder with Lottie animation and actions.
*/
ActionsPlaceholder {
    id: root

    property bool autoStartOnVisible: true

    /*! Play animation on device orientation changes */
    property bool autoStartOnIsLandscapeChanged: false

    /*! Play animation only if layout orientation changed */
    property bool autoStartOnOrientationChange: false

    property alias lottie: lottie

    property var lottieContainer: contentItemContainer

    anchors.fill: parent

    onIsLandscapeChanged: {
        if (root.autoStartOnIsLandscapeChanged) {
            lottie.start()
        }
    }

    onOrientationChanged: {
        if (root.autoStartOnOrientationChange) {
            lottie.start()
        }
    }

    onVisibleChanged: {
        if (root.visible && root.autoStartOnVisible) {
            lottie.start()
        }
    }

    contentItem: LottieAnimation {
        id: lottie

        anchors.fill: parent

        loops: 1
        autoPlay: root.autoStartOnVisible

        source: root.animationSource

        layer {
            enabled: true
            effect: ColorOverlay {
                color: Theme.highlightColor
            }
        }
    }
}
