/*
 * SPDX-FileCopyrightText: Copyright 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <memory>

#include "ipermissionrequest.h"

namespace Aurora {
namespace WebView {

class PermissionRequestInternal;

/**
 * @class PermissionRequest
 * @brief represents permission requests
 */
class PermissionRequest : public IPermissionRequest
{
    Q_GADGET
    /// unique id of the permission prompt
    Q_PROPERTY(quint64 promptId READ promptId)
    /// origin requesting the permission
    Q_PROPERTY(QString requestingOrigin READ requestingOrigin)
    /// list of requested permissions
    Q_PROPERTY(QVariantList requestedPermissions READ requestedPermissionsQML)
    /// true if this object is valid
    Q_PROPERTY(bool isValid READ isValid)
public:
    PermissionRequest();
    PermissionRequest(const PermissionRequest &other) = default;
    ~PermissionRequest() = default;

    Q_INVOKABLE void accept() override;
    Q_INVOKABLE void deny() override;

    /// Dismisses the request without providing explicit action (accept or deny)
    Q_INVOKABLE void dismiss();

    quint64 promptId() const;
    QString requestingOrigin() const override;
    QList<quint32> requestedPermissions() const override;
    QVariantList requestedPermissionsQML() const override;
    bool isValid() const override;

private:
    PermissionRequest(std::shared_ptr<PermissionRequestInternal> permissionRequestInternal);

    std::shared_ptr<PermissionRequestInternal> m_d;

    friend class PermissionRequestInternal;
};

} // namespace WebView
} // namespace Aurora

Q_DECLARE_METATYPE(Aurora::WebView::PermissionRequest)
