/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <memory>

namespace Aurora {
namespace WebView {

class JSDialogRequest;

/**
 * @class IJSDialogHandler
 * @brief Provides an interface to handle dialog alert, confirm, prompt javascipt functions calls
 * 
 * You can implement this interface to override the default JSDialogHandler.
 *
 * Browser engine starts using an external implementation as soon as it is created.
 * Please note that only the last created implementation is used. As soon as
 * a new implementation is instantiated, all previous implementations become invalid.
 */
class IJSDialogHandler
{
public:
    /**
     * @brief Construct a new IJSDialogHandler object
     */
    IJSDialogHandler();
    /**
     * @brief Destroy the IJSDownloadHandler object
     */
    virtual ~IJSDialogHandler() = default;

    /**
     * @brief called when a new alert, confirm, prompt is called from the web page
     * 
     * @param dialogRequest object that provides interaction mechanism with the request
     */
    virtual void requestJSDialog(const JSDialogRequest &jsDialogRequest) = 0;
};

} // namespace WebView
} // namespace Aurora
