/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <memory>

#include "httpauthrequest.h"

namespace Aurora {
namespace WebView {

class IClient;

/**
 * @class IAuthHandler
 * @brief You can implement this interface to override the default IAuthHandler.
 *
 * Browser engine starts using an external implementation as soon as it is created.
 * Please note that only the last created implementation is used. As soon as
 * a new implementation is instantiated, all previous implementations become invalid.
 */
class IAuthHandler
{
public:
    /// @brief Registers IAuthHandler implementations in IClient
    /// @param client can be nullptr, default one will be used in that case.
    IAuthHandler(IClient *client = nullptr);

    /// @brief default destructor
    virtual ~IAuthHandler() = default;

    /// @brief called when a server makes an authentication request
    /// @param httpAuthRequest use to handle authentication
    virtual void requestHttpAuth(const HttpAuthRequest &httpAuthRequest) = 0;
};

} // namespace WebView
} // namespace Aurora
