/****************************************************************************************
**
** SPDX-FileCopyrightText: 2013 Jolla Ltd.
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************************/


import QtQuick 2.0
import Sailfish.Silica 1.0

Grid {
    id: root

    property color color
    property var colors: ["#e60003", "#e6007c", "#e700cc", "#9d00e7",
                          "#7b00e6", "#5d00e5", "#0077e7", "#01a9e7",
                          "#00cce7", "#00e696", "#00e600", "#99e600",
                          "#e3e601", "#e5bc00", "#e78601"]
    property bool isPortrait: true

    signal colorClicked(color color)

    columns: isPortrait ? 3 : 5
    width: parent.width

    Repeater {
        model: root.colors

        Rectangle {
            height: width
            width: root.width / root.columns
            color: modelData

            MouseArea {
                id: mouseArea

                anchors.fill: parent
                cursorShape: enabled ? Qt.PointingHandCursor : Qt.ArrowCursor

                onClicked: {
                    root.color = colors[model.index]
                    root.colorClicked(root.color )
                }

                Rectangle {
                    anchors.fill: parent
                    color: Theme.rgba("white", Theme.opacityLow)
                    opacity: (mouseArea.pressed && mouseArea.containsMouse) ? 1.0 : 0.0
                }
            }
        }
    }
}
