/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

pragma Singleton
import QtQuick 2.6
import ru.auroraos.WebView 1.0

QtObject {
    function createWebView(parent, extensions) {
        var component = Qt.createComponent("WebView.qml");
        var webview = component.createObject(parent);

        // do not update webview and set default size and position
        webview.x = -10
        webview.y = -10;
        webview.height = 10;
        webview.width = 10;

        // load all extensions by default
        if (typeof extensions === "undefined") {
            extensions = [
                'FaviconExtension',
                'KeyboardInput',
                'JavaScriptFile',
                'JavaScriptString',
                'LoadRequestExtension',
                'PopupExtension',
                'MediaPlaybackStatus',
                'MouseInput',
                'OverscrollExtension',
                'PdfPrintExtension',
                'TouchInput',
                'TextSelection',
                'ContextMenu',
                'ConnectionInfo'
            ]
        }
        extensions.forEach(function(extension) {
            var component = Qt.createComponent(extension + '.qml');
            var extensionObject = component.createObject(webview);
        });

        return webview;
    }
}
