/**
 * SPDX-FileCopyrightText: 2021-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_DEVICELOCKSETTINGS_H
#define SAILFISH_MDM_DEVICELOCKSETTINGS_H

#include <QString>
#include <QDBusInterface>
#include <QObject>
#include <QSharedPointer>

#include "mdm-devicelock.h"

namespace Sailfish {
namespace Mdm {

class Q_DECL_EXPORT DeviceLockSettings : public QObject
{
    Q_OBJECT

public:
    enum ComplexPasswordPolicy {
        MaxSerialRepetitions,
        MinDigits,
        MinLetters,
        MinLowercaseLetters,
        MinUppercaseLetters,
        MinNonLetters,
        MinSpecialChars
    };
    Q_ENUM(ComplexPasswordPolicy)

    enum Generation {
        NoGeneration = 0,
        // Reserve for OptionalGeneration
        MandatoryGeneration = 2,

    };
    Q_ENUM(Generation)

    explicit DeviceLockSettings(QObject *parent = nullptr);

    static QList<Qt::DayOfWeek> fromStringScheduleDays(const QString &schedDays);
    static QPair<QTime, QTime> fromStringScheduleTime(const QString &schedTime);

    bool setPasswordStrength(bool strength);
    bool getPasswordStrength();

    DeviceLock::Result setPasswordLength(uint length);
    uint getPasswordLength();

    bool setPasswordMaxAge(uint days);
    uint getPasswordMaxAge();

    bool setPasswordWarningPeriod(uint days);
    uint getPasswordWarningPeriod();

    bool setComplexPasswordPolicy(ComplexPasswordPolicy policy, uint value);
    uint getComplexPasswordPolicy(ComplexPasswordPolicy policy);

    DeviceLock::Result setLoginTimeToLive(uint uid, QDate ttl);
    QDate getLoginTimeToLive(uint uid);

    DeviceLock::Result setScheduleDays(uint uid, const QList<Qt::DayOfWeek> &schedDays);
    QList<Qt::DayOfWeek> getScheduleDays(uint uid);

    DeviceLock::Result setScheduleTime(uint uid, const QPair<QTime, QTime> &schedTime);
    QPair<QTime, QTime> getScheduleTime(uint uid);

    DeviceLock::Result setLoginLocked(uint uid, bool value);
    bool getLoginLocked(uint uid);

    bool setPasswordGeneration(Generation generation);
    Generation getPasswordGeneration();

private:
    QDBusInterface m_iface;

    Q_DISABLE_COPY(DeviceLockSettings)
};

} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_DEVICELOCKSETTINGS_H

