/**
 * SPDX-FileCopyrightText: 2012 Digia Plc and/or its subsidiary(-ies)
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: LGPLv2
 */

#ifndef QGALLERYTRACKERCHANGENOTIFIER_P_H
#define QGALLERYTRACKERCHANGENOTIFIER_P_H

#include "qgalleryglobal.h"

#include <QObject>
#include <QTimer>

#include <libtracker-sparql/tracker-sparql.h>

QT_BEGIN_NAMESPACE_DOCGALLERY

class QGalleryTrackerChangeNotifier : public QObject
{
    Q_OBJECT
public:
    QGalleryTrackerChangeNotifier(QObject *parent = Q_NULLPTR);
    ~QGalleryTrackerChangeNotifier();

    void handleGraphUpdate(const QString &graph);
    void setConnection(TrackerSparqlConnection *con);

public Q_SLOTS:
    void itemsEdited(const QString &service);

Q_SIGNALS:
    void itemsChanged(const QList<int> &updateIds);
    void connectionReady(TrackerSparqlConnection *connection);
    void dataAvailableChanged(bool);

private:
    TrackerNotifier *m_notifier;
    QTimer m_dataAvailableTimer;
};

QT_END_NAMESPACE_DOCGALLERY

#endif
