/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>

#include <callserviceglobal.h>

#include "audiodevice.h"

namespace ru {
namespace auroraos {
namespace call {

class CALLSERVICE_EXPORT AudioControlInterface
{
public:
    virtual ~AudioControlInterface() = default;

signals:
    // Re-declare the signals in your QObject instance.
    virtual void RequestMute(bool mute) = 0;
    virtual void RequestAudioRoute(
            const QString &inputDeviceId,
            const QString &outputDeviceId) = 0;

public slots:
    virtual void UpdateAudioRouteState(
            const QList<AudioDevice> &devices,
            bool microphoneMuted,
            const QString &activeInputDeviceId,
            const QString &activeOutputDeviceId) = 0;
    virtual void UpdateAudioRoute(
            bool microphoneMuted,
            const QString &activeInputDeviceId,
            const QString &activeOutputDeviceId) = 0;
};

} // namespace call
} // namespace auroraos
} // namespace ru

Q_DECLARE_INTERFACE(ru::auroraos::call::AudioControlInterface, "ru.auroraos.call.AudioControlInterface/1.0")
