/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>

namespace Aurora {
namespace WebView {

/**
 * @class JSDialogRequest
 * @brief Represents any JavaScript dialog request
 *
 * Provides means to process JS dialogs like alert, confirm, and prompt
 */
class JSDialogRequest
{
public:
    /**
     * @brief Constructs a new JSDialogRequest object
     * This constructor is declared to register
     * this class in QML
     */
    JSDialogRequest();
    JSDialogRequest(const JSDialogRequest &other) = default;
    /**
     * @brief Destroys the DialogRequest object
     */
    virtual ~JSDialogRequest() = default;

    QString sourceUrl() const;
    QString message() const;

    virtual bool isValid() const;

protected:
    JSDialogRequest(QString originUrl, QString messageText);

private:
    QString m_originUrl;
    QString m_messageText;
};

} // namespace WebView
} // namespace Aurora
