/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <memory>

namespace Aurora {
namespace WebView {

class JSDialogRequest;

/**
 * @class IJSDialogHandler
 * @brief Interface for JSDialogHandler.
 * 
 * You can implement this interface to override default JSDialogHandler. However,
 * note that instantiating an external implementation disables default QML wrapper,
 * so you might also need to create it on your own.
 *
 * Browser engine starts using an external implementation as soon as it is created.
 * Please note that only the last created implementation is used. As soon as
 * a new implementation is instantiated, all previous implementations become invalid.
 */
class IJSDialogHandler
{
public:
    /**
     * @brief Construct a new IJSDialogHandler object
     */
    IJSDialogHandler();
    /**
     * @brief Destroy the IJSDownloadHandler object
     */
    virtual ~IJSDialogHandler() = default;

    /**
     * @brief called when a new alert, confirm, prompt is called from the web page
     * 
     * @param dialogRequest object that provides interaction mechanism with the request
     */
    virtual void requestJSDialog(const JSDialogRequest &jsDialogRequest) = 0;
};

} // namespace WebView
} // namespace Aurora
