// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef STREAMCAMERAVIDEOBUFFERNATIVE_H
#define STREAMCAMERAVIDEOBUFFERNATIVE_H

#include "StreamCameraVideoBufferI420.h"
#include "StreamCameraVideoBufferNV12.h"

#include <streamcamera/streamcamera.h>

#include "api/video/i420_buffer.h"
#include "api/video/video_frame_buffer.h"

#include <memory>

class StreamCameraVideoBufferNative : public webrtc::VideoFrameBuffer
{
public:
    static rtc::scoped_refptr<StreamCameraVideoBufferNative> Create(
        std::shared_ptr<const Aurora::StreamCamera::YCbCrFrame> frame)
    {
        return rtc::make_ref_counted<StreamCameraVideoBufferNative>(frame);
    }

    static rtc::scoped_refptr<StreamCameraVideoBufferNative> Create(
        std::shared_ptr<Aurora::StreamCamera::GraphicBuffer> graphicBuffer)
    {
        return rtc::make_ref_counted<StreamCameraVideoBufferNative>(graphicBuffer);
    }

    StreamCameraVideoBufferNative(std::shared_ptr<const Aurora::StreamCamera::YCbCrFrame> frame)
        : ycbcr_(frame)
    {}

    StreamCameraVideoBufferNative(
        std::shared_ptr<Aurora::StreamCamera::GraphicBuffer> graphicBuffer)
        : graphicBuffer_(graphicBuffer)
        , ycbcr_(graphicBuffer_->mapYCbCr())
    {}

    Type type() const override { return Type::kNative; }

    int width() const override { return ycbcr_->width; }
    int height() const override { return ycbcr_->height; }

    rtc::scoped_refptr<webrtc::I420BufferInterface> ToI420() override
    {
        if (ycbcr_->chromaStep == 1)
            return StreamCameraVideoBufferI420::Create(ycbcr_);
        else if (ycbcr_->chromaStep == 2) {
            auto buffer = StreamCameraVideoBufferNV12::Create(ycbcr_);
            return buffer->ToI420();
        }
        return nullptr;
    }

    std::shared_ptr<Aurora::StreamCamera::GraphicBuffer> graphicBuffer_ = nullptr;
    std::shared_ptr<const Aurora::StreamCamera::YCbCrFrame> ycbcr_ = nullptr;
    int encoderRotationAngle_ = 0;
};

#endif // STREAMCAMERAVIDEOBUFFERNATIVE_H
