/**
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>
#include <QVariantMap>
#include <QString>

#include "callserviceglobal.h"

namespace ru {
namespace auroraos {
namespace call {

class Call;
class CallManager;

class CALLSERVICE_EXPORT CallFactoryInterface
{
public:
    virtual Call *newCall(CallManager *manager,
                          const QString &id,
                          const QVariantMap &parameters,
                          QObject *parent = nullptr) = 0;
    virtual ~CallFactoryInterface() = default;
};

} // namespace call
} // namespace auroraos
} // namespace ru

#define CallFactoryInterface_iid "ru.auroraos.call.callfactory/1.0"
Q_DECLARE_INTERFACE(ru::auroraos::call::CallFactoryInterface, CallFactoryInterface_iid);
