// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Claus

#ifndef AUTHINAPPTAB_H
#define AUTHINAPPTAB_H

#include "inapptabbase.h"

/**
 * @brief AuthInAppTab implementation calling "LoadAuthPage" for authentication flows.
 */
class AuthInAppTab : public InAppTabBase
{
    Q_OBJECT
public:
    explicit AuthInAppTab(ActionListType type = Base, QObject *parent = nullptr);

signals:
    void finished(const QString &resultUrl);

protected:
    void sendOpenRequest(const QString &url, bool advancedAccessibility) override;
    void connectExtraSignals() override;

private slots:
    void onFinished(const QString &resultUrl);
};

#endif // AUTHINAPPTAB_H
