/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef MANAGER_HPP_
#define MANAGER_HPP_

#include "usb.hpp"
#include "usbserial.hpp"

#include <QVector>

namespace Aurora {
namespace Devices {

class ManagerPrivate;
class Manager : public QObject
{
    Q_OBJECT

public:
    Manager(QObject *parent = nullptr);
    ~Manager() = default;

    QVector<UsbDevicePtr> getUsbDevices();
    QVector<UsbSerialDevicePtr> getUsbSerialDevices();

signals:
    void usbDevicesUpdated();
    void usbSerialDevicesUpdated();

private:
    Manager(const Manager &other) = delete;
    Manager(Manager &&other) = delete;

    ManagerPrivate *d_ptr;
    Q_DECLARE_PRIVATE(Manager)
};

} // namespace Devices
} // namespace Aurora

#endif // MANAGER_HPP_
