/*
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>

#include "iclient.h"
#include "ishutdownhandler.h"

class QQmlEngine;
class QJSEngine;

namespace Aurora {
namespace WebView {

/**
 * @class ShutdownHandler
 * @brief Use this singleton to shutdown the WebView
 *
 * WebView shutdown happens automatically on application exit, however,
 * you can also use this handler in case you need to perform a manual shutdown.
 *
 */
class ShutdownHandler : public QObject, public IShutdownHandler
{
    Q_OBJECT
public:
    /// @brief default destructor
    ~ShutdownHandler() = default;

    /// @brief creates (if doesn't exist) and returns an instance of ShutdownHandler
    /// @return ShutdownHandler instance
    static QSharedPointer<ShutdownHandler> GetInstance(
        QQmlEngine *qmlEngine = nullptr, QJSEngine *jsEngine = nullptr);

    /// @brief terminate the browser engine and the WebView
    ///
    ///  After completion, the WebView posts ReadyToClose QT event.
    Q_INVOKABLE void shutdown();

private:
    explicit ShutdownHandler(IClient *client);
};

} // namespace WebView
} // namespace Aurora
