/*
 * SPDX-FileCopyrightText: Copyright 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>

namespace Aurora {
namespace WebView {

class IDownloadHandler;
class IPdfPrintHandler;
class IPopupHandler;
class IPermissionHandler;
class IDialogHandler;
class IJSDialogHandler;
class ISslHandler;
class IAuthHandler;
class IShutdownHandler;

class IClient : public QObject
{
    Q_OBJECT
public:
    virtual void setDownloadHandler(Aurora::WebView::IDownloadHandler *downloadHandler) = 0;
    virtual void setPdfPrintHandler(Aurora::WebView::IPdfPrintHandler *pdfPrintHandler) = 0;
    virtual void setPopupHandler(Aurora::WebView::IPopupHandler *popupHandler) = 0;
    virtual void setPermissionHandler(Aurora::WebView::IPermissionHandler *permissionHandler) = 0;
    virtual void setDialogHandler(Aurora::WebView::IDialogHandler *dialogHandler) = 0;
    virtual void setJSDialogHandler(Aurora::WebView::IJSDialogHandler *jsDialogHandler) = 0;
    virtual void setSslHandler(Aurora::WebView::ISslHandler *sslHandler) = 0;
    virtual void setAuthHandler(Aurora::WebView::IAuthHandler *authHandler) = 0;
    virtual void setShutdownHandler(Aurora::WebView::IShutdownHandler *shutdownHandler) = 0;
};

} // namespace WebView
} // namespace Aurora
