/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "browserextension.h"
#include "enums/types.h"
#include <QObject>

namespace Aurora {
namespace WebView {

struct PdfPrintSettings
{
    bool landscape = true;
    bool printBackground = true;;
    double scale = 1.0;
    double paperWidth = 8.5;
    double paperHeight = 11;
    bool preferCssPageSize = true;
    PdfPrintMarginType::MarginType marginType = PdfPrintMarginType::MarginType::PDF_PRINT_MARGIN_DEFAULT;
    double marginTop = 0;
    double marginRight = 0;
    double marginBottom = 0;
    double marginLeft = 0;
    QString pageRanges;
    bool generateTaggedPdf = false;
    bool generateDocumentOutline = false;
};

/**
 * @class IPdfPrintExtension
 * @brief extension that provides saving a web page as a pdf
 */
class IPdfPrint : public QObject, public Cef::BrowserExtension
{
    Q_OBJECT
public:
    IPdfPrint(Cef::Browser &browser) : Cef::BrowserExtension(browser) {}
    virtual ~IPdfPrint() = default;

    /**
     * @brief used to save loaded web page as a pdf file
     * 
     * @param path path to a file where the web page should be saved
     * @param settings print settings
     */
    virtual void printToPdf(const QString &path, const PdfPrintSettings &settings) = 0;

signals:
    /**
     * @brief the signal is emitted when the pdf print result is available
     * 
     * @param result true when the web page has been successfully saved in PDF format
     * @param path path to the saved PDF file
     */
    void pdfPrintResultAvailable(bool result, QString path);
};

} // namespace WebView
} // namespace Aurora
