// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef STREAMCAMERAINFO_H
#define STREAMCAMERAINFO_H

#include <streamcamera/streamcamera.h>

#include <vector>

class StreamCameraInfo
{
public:
    StreamCameraInfo(Aurora::StreamCamera::CameraManager &camera_manager)
        : camera_manager_(camera_manager)
    {
        update();
    }
    ~StreamCameraInfo() = default;

    void update()
    {
        camera_info_list_.clear();
        camera_caps_list_.clear();
        camera_count_ = camera_manager_.getNumberOfCameras();
        for (size_t idx = 0; idx < camera_count_; ++idx) {
            Aurora::StreamCamera::CameraInfo info;
            if (!camera_manager_.getCameraInfo(idx, info))
                continue;
            camera_info_list_.emplace_back(info);
        }
        for (auto info : camera_info_list_) {
            caps_t caps;
            if (!camera_manager_.queryCapabilities(info.id, caps))
                continue;
            camera_caps_list_.emplace_back(caps);
        }
    }

    Aurora::StreamCamera::CameraManager &camera_manager_;
    size_t camera_count_ = 0;
    std::vector<Aurora::StreamCamera::CameraInfo> camera_info_list_;
    typedef std::vector<Aurora::StreamCamera::CameraCapability> caps_t;
    std::vector<caps_t> camera_caps_list_;
};

#endif // STREAMCAMERAINFO_H
