/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef MDMVPNMANAGER_P_H
#define MDMVPNMANAGER_P_H

#include "mdm-vpnmanager.h"

#include <QDBusInterface>
#include <QDBusObjectPath>
#include <QVariantMap>
#include <QHash>
#include <QPair>
#include <QDBusArgument>
#include <QMetaType>
#include <QDBusMetaType>

using PathProperties = QPair<QDBusObjectPath, QVariantMap>;
Q_DECLARE_METATYPE(PathProperties)

using PathPropertiesArray = QList<PathProperties>;
Q_DECLARE_METATYPE(PathPropertiesArray)

QDBusArgument &operator<<(QDBusArgument &arg, const PathProperties &props);
const QDBusArgument &operator>>(const QDBusArgument &arg, PathProperties &props);

namespace Aurora {
namespace Mdm {
namespace Connectivity {

class VpnProfilePrivate : public QObject {
    Q_OBJECT

public:
    using Error = VpnProfile::Error;
    using State = VpnProfile::State;
    using VpnCallback = void (VpnProfile::*)(Error);

    VpnProfilePrivate(const QString &path, VpnManager *manager, VpnProfile *parent);

    void applyParams(const QVariantMap &params);
    void updateProperty(const QString &key, const QVariant &value);
    void setProperty(QDBusInterface &iface, const QString &key, const QVariant &value, VpnCallback callback);
    void setState(State value);
    void setValid(bool value);

public slots:
    void onPropertyChanged(const QString &key, const QDBusVariant &value);

public:
    QString path;
    QDBusInterface iface;
    QDBusInterface serviceIface;
    VpnManager *manager;

    QString name;
    QString host;
    QString domain;
    QString type;
    bool splitTraffic = false;
    bool autoConnect = false;
    QVariantMap providerProperties;
    State state = State::Failure;
    bool valid = true;

    VpnProfile *q_ptr;
};

class VpnManagerPrivate : public QObject {
    Q_OBJECT

public:
    VpnManagerPrivate(VpnManager *parent);

    QSharedPointer<VpnProfile> addProfile(const QString &path, const QVariantMap &params);
    void removeProfile(const QString &path);

public slots:
    void onVpnAdded(const QDBusObjectPath &path, const QVariantMap &params);
    void onVpnRemoved(const QDBusObjectPath &path);

public:
    QDBusInterface iface;
    QHash<QString, QSharedPointer<VpnProfile>> profiles;
    quint64 maxId = 1;
    VpnManager *q_ptr;
};

} // namespace Connectivity
} // namespace Mdm
} // namespace Aurora

#endif // MDMVPNMANAGER_P_H
