/**
 * SPDX-FileCopyrightText: Copyright 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QString>
#include <QObject>
#include <QDBusObjectPath>
#include <QDBusPendingCallWatcher>

#include "callserviceglobal.h"
#include "callfactoryinterface.h"

namespace ru {
namespace auroraos {
namespace call {

class Call;
class CallManagerPrivate;

class CALLSERVICE_EXPORT CallManager : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QString id READ id)
    Q_PROPERTY(bool valid READ valid NOTIFY validChanged)
    Q_PROPERTY(QString error READ error NOTIFY errorChanged)
    Q_PROPERTY(QStringList calls READ calls NOTIFY callsChanged)

public:
    explicit CallManager(const QString &id, QObject *parent = nullptr);
    explicit CallManager(const QString &id, const QString &iconPath, QObject *parent = nullptr);
    virtual ~CallManager();

    void setCallFactory(CallFactoryInterface *callFactory);

    QString id() const;

    Q_INVOKABLE void registerCallManager();
    Q_INVOKABLE Call *newCall(const QString &id, const QVariantMap &parameters);
    Q_INVOKABLE Call *getCall(const QString &id) const;
    Q_INVOKABLE bool removeCall(const QString &id);

    bool valid() const;
    QString error() const;
    QStringList calls() const;

signals:
    void validChanged(bool);
    void errorChanged(const QString &error);
    void callAdded(const QString &id);
    void callRemoved(const QString &id);
    void callsChanged(const QStringList &calls);

private:
    Q_DISABLE_COPY(CallManager)
    Q_DECLARE_PRIVATE(CallManager)
    CallManagerPrivate *d_ptr;
};

} // namespace call
} // namespace auroraos
} // namespace ru
