/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef USBSERIAL_HPP_
#define USBSERIAL_HPP_

#include "device.hpp"

namespace Aurora {
namespace Devices {

class UsbSerial : public BaseDevice
{
    Q_OBJECT

    Q_PROPERTY(QString sysPath READ sysPath CONSTANT)
    Q_PROPERTY(QString deviceClass READ deviceClass CONSTANT)
    Q_PROPERTY(QString vendorId READ vendorId CONSTANT)
    Q_PROPERTY(QString productId READ productId CONSTANT)
    Q_PROPERTY(QString serial READ serial CONSTANT)
    Q_PROPERTY(QString manufacturer READ manufacturer CONSTANT)
    Q_PROPERTY(QString product READ product CONSTANT)
    Q_PROPERTY(QString productVersion READ productVersion CONSTANT)

public:
    UsbSerial(const QString &objectPath, const QVariantMap &properties, QObject *parent = nullptr);
    ~UsbSerial() = default;

    int fileDescriptor();

    QString sysPath() const;
    QString deviceClass() const;
    QString vendorId() const;
    QString productId() const;
    QString serial() const;
    QString manufacturer() const;
    QString product() const;
    QString productVersion() const;
};

using UsbSerialDevicePtr = QSharedPointer<UsbSerial>;

} // namespace Devices
} // namespace Aurora

#endif // USBSERIAL_HPP_
