/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "iauthhandler.h"

#include "iclient.h"

#include <QObject>

class QQmlEngine;
class QJSEngine;

namespace Aurora {
namespace WebView {

/**
 * @class AuthHandler
 * @brief Authentication handler
 * 
 * Use this singleton to handle HTTP authentication requests
 */
class AuthHandler : public QObject, public IAuthHandler
{
    Q_OBJECT
public:
    /// @brief default destructor
    virtual ~AuthHandler() = default;

    /// @brief creates (if doesn't exist) and returns an instance of AuthHandler
    /// @return AuthHandler instance
    static QSharedPointer<AuthHandler> GetInstance(QQmlEngine *qmlEngine, QJSEngine *jsEngine);

    void requestHttpAuth(const HttpAuthRequest &httpAuthRequest) override;

signals:
    /// @brief emitted when http authentication is requested
    /// @param httpAuthRequest use to handle authentication
    void httpAuthRequested(HttpAuthRequest httpAuthRequest);

private:
    explicit AuthHandler(IClient *client);
};

} // namespace WebView
} // namespace Aurora
