/**
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QDateTime>
#include <QSharedPointer>
#include <QList>

namespace Aurora {
namespace Contacts {

class ContactPrivate;
class PhonePrivate;
class ContactNamePrivate;

class Q_DECL_EXPORT Phone
{
    Q_GADGET

    Q_PROPERTY(QString number READ number CONSTANT)
    Q_PROPERTY(PhoneType type READ getType CONSTANT)

public:
    enum PhoneType {
        NO_TYPE = 0,
        MOBILE,
        WORK,
        HOME,
        MAIN,
        OTHER,
        CUSTOM
    };
    Q_ENUM(PhoneType)

    explicit Phone();
    virtual ~Phone() = default;

    const QString &number() const;
    Phone::PhoneType getType() const;

private:
    QSharedPointer<PhonePrivate> d;
    friend class ContactsManagerPrivate;
};

class Q_DECL_EXPORT ContactName
{
    Q_GADGET

    Q_PROPERTY(QString firstName READ firstName CONSTANT)
    Q_PROPERTY(QString middleName READ middleName CONSTANT)
    Q_PROPERTY(QString lastName READ lastName CONSTANT)
    Q_PROPERTY(QString nickName READ nickName CONSTANT)

public:
    explicit ContactName();
    virtual ~ContactName() = default;

    QString firstName() const;
    QString middleName() const;
    QString lastName() const;
    QString nickName() const;

private:
    QSharedPointer<ContactNamePrivate> d;
    friend class ContactsManagerPrivate;
};

class Q_DECL_EXPORT Contact
{
    Q_GADGET

    Q_PROPERTY(ContactName contactName READ contactName CONSTANT)
    Q_PROPERTY(QList<Phone> phones READ phones CONSTANT)
    Q_PROPERTY(int contactId READ contactId CONSTANT)
    Q_PROPERTY(QString avatar READ avatar CONSTANT)

public:
    explicit Contact();
    virtual ~Contact();
    bool operator==(const Contact &other) const;

    ContactName contactName() const;
    QList<Phone> phones() const;
    int contactId() const;
    QString avatar() const;

private:
    QSharedPointer<ContactPrivate> d;
    friend class ContactsManagerPrivate;
};

}
}

Q_DECLARE_METATYPE( Aurora::Contacts::ContactName * )
Q_DECLARE_METATYPE( Aurora::Contacts::ContactName )
Q_DECLARE_METATYPE( Aurora::Contacts::Phone* )
