/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "webview.h"

namespace Aurora {
namespace WebView {

/**
 * @class WebViewPrivate
 * @brief Represents a private WebView instance that renders webpages.
 *
 * WebViewPrivate is exactly the same as WebView, but it doesn't store cache (website data) on disk.
 *
 * For instance, private web browser tabs could be implemented as distinct WebViewPrivate instances.
 *
 */
class WebViewPrivate : public WebView
{
    Q_OBJECT
public:
    WebViewPrivate(QObject *parent = Q_NULLPTR);
};

} // namespace WebView
} // namespace Aurora
