/*
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <memory>

namespace Aurora {
namespace WebView {

class IClient;

/**
 * @class IShutdownHandler
 * @brief Provides the client with an interface for ShutdownHandler QML singleton
 */
class IShutdownHandler
{
public:
    /// @brief Registers IShutdownHandler implementations in client
    /// @param client client for registration of the implementation
    IShutdownHandler(IClient *client = nullptr);

    /// @brief default destructor
    virtual ~IShutdownHandler() = default;

    /// @brief called to start shutdown process
    virtual void shutdown() = 0;
};

} // namespace WebView
} // namespace Aurora
