/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "dialogrequest.h"

#include <memory>

namespace Aurora {
namespace WebView {

/**
 * @class IDialogHandler
 * @brief Provides an interface to handle dialog requests (like file or folder picking)
 * 
 * You can implement this interface to override the default DialogHandler.
 *
 * Browser engine starts using an external implementation as soon as it is created.
 * Please note that only the last created implementation is used. As soon as
 * a new implementation is instantiated, all previous implementations become invalid.
 */
class IDialogHandler
{
public:
    /**
     * @brief Construct a new IDialogHandler object
     */
    IDialogHandler();
    /**
     * @brief Destroy the IDownloadHandler object
     */
    virtual ~IDialogHandler() = default;

    /**
     * @brief called when a new file/folder dialog is requested
     * 
     * @param dialogRequest object that provides interaction mechanism with the request
     */
    virtual void requestFileDialog(const DialogRequest &dialogRequest) = 0;
};

} // namespace WebView
} // namespace Aurora
