// SPDX-FileCopyrightText: 2016 Jolla Ltd.
// SPDX-FileCopyrightText: 2019 Open Mobile Platform LLC <community@omp.ru>
// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "operation.h"

class AddSfdkDeviceModelOperation : public Operation
{


public:
    AddSfdkDeviceModelOperation();
    QString name() const;
    QString helpText() const;
    QString argumentsHelpText() const;

    bool setArguments(const QStringList &args);

    int execute() const;

#ifdef WITH_TESTS
    bool test() const;
#endif

    static QVariantMap addDeviceModel(const QVariantMap &map, const QString &name,
                                      int hres, int vres, int hsize, int vsize,
                                      const QString &dconfDb);
    static QVariantMap initializeDeviceModels(const QString &installDir, int version = -1);

private:
    QString m_installDir;
    QString m_name;
    int m_hres{0};
    int m_vres{0};
    int m_hsize{0};
    int m_vsize{0};
    QString m_dconfDb;
};
