#!/bin/sh

tracker_service="tracker-miner-fs-3.service"

start_tracker() {
    systemctl start --user "$tracker_service"
}

stop_tracker() {
    systemctl stop --user "$tracker_service"
}

start_tracker
if [ $? -ne 0 ]; then
    echo "Failed to start $tracker_service"
    exit 1
fi

res=$(tracker3 sparql --dbus-service=org.freedesktop.Tracker3.Miner.Files --search=hidden | grep -q hidden)

if [ -z ${res} ] || [ ! -e ~/.local/share/tracker-migrated ] ; then
    stop_tracker
    rm -rf ~/.cache/tracker3
    start_tracker
    touch ~/.local/share/tracker-migrated
fi
