/*
 * SPDX-FileCopyrightText: 2015-2020 Jolla Ltd.
 * SPDX-FileCopyrightText: 2029-2025 Open Mobile Platform LLC <community@omp.ru>
 *
 * SPDX-License-Identifier: Proprietary
*/

import QtQuick 2.6
import Sailfish.Silica.private 1.0

QtObject {
    id: filters

    property var filterNames: [ "glassBlur", "glassBlurDark", "glassBlurLight", "auroraBlur", "auroraBlurDark", "auroraBlurLight", "auroraBasicBlur" ]

    property list<QtObject> objects
    default property alias _objects: filters.objects

    property SequenceFilterPrivate glassBlur: GlassBlur {
        saturationMultiplier: 1.5
    }

    property SequenceFilterPrivate glassBlurDark: GlassBlurDark {
    }

    property SequenceFilterPrivate glassBlurLight: GlassBlurLight {
    }

    property SequenceFilterPrivate auroraBlur: AuroraBlur {
    }

    property SequenceFilterPrivate auroraBlurDark: AuroraBlur {
        isLightScheme: false
    }

    property SequenceFilterPrivate auroraBlurLight: AuroraBlur {
        isLightScheme: true
    }

    property SequenceFilterPrivate auroraBasicBlur: AuroraBlur {
        colorCorrection: false
    }
}
