/**
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_MDM_MANAGED_CONFIGURATION_P_H
#define AURORA_MDM_MANAGED_CONFIGURATION_P_H

#include "mdm-managedconfiguration.h"
#include "base-mdm-proxy-interface_p.h"

#include <QDBusConnection>
#include <QDBusInterface>

namespace Aurora {
namespace Mdm {

class ManagedConfigurationValuePrivate
{
public:
    using ConfigurationType = ManagedConfigurationValue::ConfigurationType;
    using Reason = ManagedConfigurationValue::Reason;
    using Type = ManagedConfigurationValue::Type;
    using Detail = ManagedConfigurationValue::Detail;

    ManagedConfigurationValuePrivate();
    ManagedConfigurationValuePrivate(Type type, QVariant value);
    ManagedConfigurationValuePrivate(const ManagedConfigurationValuePrivate &other);
    ~ManagedConfigurationValuePrivate() = default;

    ManagedConfigurationValue toManagedConfigurationValue();

    Type type() const;
    QVariant value() const;
    bool set(Type type, const QVariant &value);
    bool isValid() const;

    QString title() const;
    QString description() const;
    QVariant getDetail(Detail detail) const;
    void addDetail(Detail detail, const QVariant &variant);

private:
    QMap<Detail, QVariant> m_details;
};

class ManagedConfigurationPrivate
{
public:
    ManagedConfigurationPrivate() = default;

    QStringList keys() const;
    ManagedConfigurationValue get(const QString &key) const;
    void add(const QString &key, const ManagedConfigurationValue &value);

private:
    QMap<QString, ManagedConfigurationValue> m_data;
};

class ManagedConfigurationManagerPrivate : public BaseMdmProxyInterface
{
    Q_OBJECT

public:
    using GetConfigurationCallback = ManagedConfigurationManager::GetConfigurationCallback;
    using ChangeConfigurationCallback = ManagedConfigurationManager::ChangeConfigurationCallback;
    using Error = ManagedConfigurationManager::Error;

    ManagedConfigurationManagerPrivate(ManagedConfigurationManager *parent);

    std::tuple<QStringList, Error> getApplications();
    void getConfiguration(const QString &applicationId,
                          int userId,
                          const GetConfigurationCallback &callback);
    void changeConfiguration(const QString &applicationId,
                             int userId,
                             const ManagedConfiguration &configuration,
                             const ChangeConfigurationCallback &callback);

private:
    Q_DISABLE_COPY(ManagedConfigurationManagerPrivate)
};

} // namespace Mdm
} // namespace Aurora

#endif // AURORA_MDM_MANAGED_CONFIGURATION_P_H
