/****************************************************************************
**
** Copyright (c) 2023 Open Mobile Platform LLC.
**
** License: Proprietary
**
****************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0

BackgroundItem {
    id: root

    property alias text: label.text
    property alias iconSource: icon.source
    property alias iconSourceRight: iconRight.source
    property alias horizontalAlignmentText: label.horizontalAlignment
    property int horizontalOffset
    property alias iconWidth: iconContainer.width

    width: parent.width

    Item {
        id: iconContainer

        width: icon.source != "" ? icon.width : 0
        height: parent.height
        x: Theme.paddingMedium

        Icon {
            id: icon

            anchors {
                centerIn: parent
                horizontalCenterOffset: horizontalOffset
            }
            highlighted: root.highlighted
            color: Theme.primaryColor
            opacity: root.enabled ? 1.0 : Theme.opacityLow
        }
    }
    Label {
        id: label

        anchors {
            left: iconContainer.right
            leftMargin: Theme.paddingMedium
            right: parent.right
            rightMargin: iconContainerRight.visible ? iconContainerRight.width + Theme.paddingMedium : Theme.horizontalPageMargin
            verticalCenter: parent.verticalCenter
        }
        color: root.highlighted ? Theme.highlightColor : Theme.primaryColor
        opacity: root.enabled ? 1.0 : Theme.opacityLow
        truncationMode: TruncationMode.Fade

        Behavior on opacity { FadeAnimation {} }
    }
    Item {
        id: iconContainerRight

        width: iconRight.width + Theme.paddingMedium * 2
        height: parent.height
        anchors.right: parent.right
        visible: iconRight.source != ""

        Icon {
            id: iconRight

            anchors {
                centerIn: parent
                horizontalCenterOffset: horizontalOffset
            }
            highlighted: root.highlighted
            color: Theme.primaryColor
            opacity: root.enabled ? 1.0 : Theme.opacityLow
        }
    }
}
