/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Controls 1.0
import Aurora.Controls.private 1.0
import QtGraphicalEffects 1.0

PopupBase {
    id: root

    default property alias children: contentContainer.children
    property alias _backgroundColor: popupBackground.color

    width: implicitWidth
    height: Math.min(implicitHeight, contentHeight)
    contentHeight: Theme.dp(72) * 5
    contentWidth: Math.max(Screen.width, Screen.height) * 0.33333333 - Theme.horizontalPageMargin
    preferredWidth: Math.max(Screen.width, Screen.height) * 0.33333333 - Theme.horizontalPageMargin
    preferredHeight: Theme.dp(72) * 5

    backgroundItem: RectangularGlow {
        scale: progress
        opacity: progress
        transformOrigin: contentContainer.transformOrigin
        cornerRadius: Theme.dp(24)
        glowRadius: cornerRadius
        color: Theme.colorScheme == Theme.DarkOnLight ? "#19000000" : "#33000000"

        Rectangle {
            id: popupBackground

            anchors.fill: parent

            color: Qt.tint(Theme.rgba(palette.highlightColor, 1.0),
                           palette.colorScheme == Theme.DarkOnLight ? "#ccffffff" : "#cc000000")
            radius: Theme.paddingMedium
            border.width: Theme._lineWidth
            border.color: Theme.rgba(palette.primaryColor, 0.1)
        }
    }

    contentItem: Item {
        id: contentContainer

        width: root.width
        height: root.height

        scale: progress
        opacity: progress
        layer.enabled: true
        layer.effect: OpacityMask {
            maskSource: Rectangle {
                anchors.fill: contentContainer
                visible: false
                color: "black"
                radius: popupBackground.radius * 0.85
            }
        }

        InverseMouseArea {
            onPressedOutside: close()

            anchors.fill: parent
            stealPress: true
        }
    }
}
