/*
 * SPDX-FileCopyrightText: 2020-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef PERMISSIONSMODEL_H
#define PERMISSIONSMODEL_H

#include <QAbstractListModel>
#include <QMap>
#include "systemsettingsglobal.h"

class MPermission;

class SYSTEMSETTINGS_EXPORT PermissionsModel: public QAbstractListModel
{
    Q_OBJECT
    Q_PROPERTY(QString desktopFile READ desktopFile WRITE setDesktopFile NOTIFY desktopFileChanged)
    Q_PROPERTY(int count READ rowCount NOTIFY countChanged)

public:
    explicit PermissionsModel(QObject *parent = nullptr);
    ~PermissionsModel();

    enum Roles {
        DescriptionRole = Qt::UserRole,
        LongDescriptionRole,
        NameRole,
    };

    QString desktopFile() const;
    void setDesktopFile(QString file);

    QHash<int, QByteArray> roleNames() const;
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;

signals:
    void desktopFileChanged();
    void countChanged();

private:
    void loadPermissions();

    QString m_desktopFile;
    QList<MPermission> m_permissions;
    QMap<QString, int> m_requiredInterfaceCountByPackage;
};

#endif // PERMISSIONSMODEL_H
