/**
 * SPDX-FileCopyrightText: 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.2
import Sailfish.Silica 1.0
import Sailfish.FileManager 1.0
import Nemo.FileManager 1.0
import Aurora.Controls 1.0

PopupMenu {
    id: root

    property alias availableSortExtension: items.availableSortExtension

    signal sortClicked(int sortOrder, int sortBy, int directorySort)

    //% "Sort by"
    headerText: qsTrId("filemanager-he-sort")
    headerBackground: PopupMenuHeader.SolidBackground
    preferredHeight: Math.max(Screen.width, Screen.height)
    preferredWidth: Screen.sizeCategory > Screen.Medium
                    ?  Math.max(Screen.width, Screen.height) * 0.33333333 - Theme.horizontalPageMargin
                    :  Math.min(Screen.width, Screen.height) - Theme.horizontalPageMargin * 2

    PopupMenuSortItems {
        id: items

        onSortClicked: root.sortClicked(sortOrder, sortBy, directorySort)
    }
}
