/*
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef DISKUSAGEMODEL_H
#define DISKUSAGEMODEL_H

#include "systemsettingsglobal.h"

#include <QAbstractListModel>

class DiskUsageModelPrivate;

class SYSTEMSETTINGS_EXPORT DiskUsageModel: public QAbstractListModel
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(DiskUsageModel)

public:
    enum Roles {
        LabelRole = Qt::UserRole,
        BytesRole,
        PositionRole,
        PathRole,
        PathAllowedRole,
        DBusServiceRole,
        DBusPathRole,
        DBusInterfaceRole,
        DBusMethodRole,
        DBusArgumentRole,
    };
    Q_ENUM(Roles)

    Q_PROPERTY(quint64 bytesTotal READ bytesTotal NOTIFY bytesTotalChanged)
    Q_PROPERTY(quint64 bytesUsed READ bytesUsed NOTIFY bytesUsedChanged)
    Q_PROPERTY(quint64 bytesAvailable READ bytesAvailable NOTIFY bytesAvailableChanged)
    Q_PROPERTY(QString storageType READ storageType WRITE setStorageType NOTIFY storageTypeChanged)
    Q_PROPERTY(bool working READ working NOTIFY workingChanged)

    explicit DiskUsageModel(QObject *parent = 0);
    ~DiskUsageModel();

    QHash<int, QByteArray> roleNames() const;
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    bool setData(const QModelIndex &, const QVariant &, int role = Qt::EditRole);

    quint64 bytesTotal() const;
    quint64 bytesUsed() const;
    quint64 bytesAvailable() const;
    QString storageType() const;
    bool working() const;

    void setStorageType(QString storageType);
    Q_INVOKABLE void refresh();

signals:
    void bytesTotalChanged();
    void bytesUsedChanged();
    void bytesAvailableChanged();
    void storageTypeChanged();
    void workingChanged();

private:
    DiskUsageModelPrivate *const d_ptr;

    friend class DiskUsageModelPrivate;
};

#endif /* DISKUSAGEMODEL_H */
