/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

import Aurora.Controls 1.0
import Nemo.FileManager 1.0

PopupMenuItem {
    property FileModel fileModel
    property int sortBy

    onClicked: {
        if (fileModel.sortBy === sortBy) {
            fileModel.sortOrder = fileModel.sortOrder == Qt.AscendingOrder
                                  ? Qt.DescendingOrder
                                  : Qt.AscendingOrder
            return
        }

        fileModel.sortBy = sortBy
        fileModel.sortOrder = Qt.AscendingOrder
    }

    secondaryIcon.visible: fileModel.sortBy === sortBy
    secondaryIcon.source: fileModel.sortOrder == Qt.AscendingOrder
                          ? "image://theme/icon-splus-sort-asc"
                          : "image://theme/icon-splus-sort-desc"
    closeOnClick: false
}
