/**
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.2
import Sailfish.Silica 1.0
import Aurora.Controls 1.0
import Nemo.FileManager 1.0
import Sailfish.FileManager 1.0

Repeater {
    id: root

    property bool availableSortExtension: true

    signal sortClicked(int sortOrder, int sortBy, int directorySort)

    model: ListModel {
        ListElement {
            sortBy: FileModel.SortByName
            directorySort: FileModel.SortDirectoriesBeforeFiles
            label: "components-filemanager-la-sorted_by_name"
        }
        ListElement {
            sortBy: FileModel.SortBySize
            directorySort: FileModel.SortDirectoriesBeforeFiles
            label: "components-filemanager-la-sorted_by_size"
        }
        ListElement {
            sortBy: FileModel.SortByModified
            directorySort: FileModel.SortDirectoriesBeforeFiles
            label: "components-filemanager-la-sorted_by_date_modified"
        }
        ListElement {
            sortBy: FileModel.SortByExtension
            directorySort: FileModel.SortDirectoriesBeforeFiles
            label: "components-filemanager-la-sorted_by_extension"
        }
    }
    delegate: PopupMenuItem {
        property bool isSelected: SortingSettings.sortBy === model.sortBy && SortingSettings.directorySort === model.directorySort
        property int sortOrder:  SortingSettings.sortOrder

        function capitalize(s) {
            return s[0].toUpperCase() + s.slice(1)
        }
        onClicked: {
            if (isSelected) {
                sortOrder = (sortOrder == Qt.AscendingOrder ? Qt.DescendingOrder : Qt.AscendingOrder)
            }

            sortClicked(sortOrder, model.sortBy, model.directorySort)
        }

        visible: model.sortBy === FileModel.SortByExtension ? availableSortExtension : true
        text: capitalize(qsTrId(label))
        closeOnClick: false
        secondaryIcon.visible: isSelected
        // The sort order is messed up at the engine level due to this value being reversed
        secondaryIcon.source: sortOrder == Qt.AscendingOrder ? "image://theme/icon-splus-sort-asc" : "image://theme/icon-splus-sort-desc"

        Rectangle {
            anchors{
                fill: parent
                leftMargin: Theme.paddingSmall
                rightMargin: Theme.paddingSmall
            }
            color: isSelected && !_highlighted
                   ? Theme.rgba(palette.highlightColor, 0.2)
                   : "transparent"
            radius: Theme.paddingSmall
            z: -1
        }
    }
}
