/*
 * Copyright (c) 2023 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import com.jolla.settings 1.0

ListItem {
    id: providerDelegate

    property bool checked: false

    contentHeight: visible ? Theme.itemSizeSmall : 0

    AccountIcon {
        id: icon

        x: SettingsUtils.isSettingsApplication ? Theme.paddingLarge : Theme.horizontalPageMargin
        anchors.verticalCenter: parent.verticalCenter
        source: model.providerIcon
    }
    Label {
        anchors {
            left: icon.right
            right: parent.right
            leftMargin: Theme.paddingLarge
            rightMargin: Theme.horizontalPageMargin
            verticalCenter: parent.verticalCenter
        }
        truncationMode: TruncationMode.Fade
        text: model.providerDisplayName
        color: highlighted ? Theme.highlightColor : Theme.primaryColor
    }

    Component.onCompleted: {
        if (!SettingsUtils.isSettingsApplication) {
            return
        }

        contentItem.color = Qt.binding(function() {
            return providerDelegate._showPress || providerDelegate.checked
                   ? Theme.rgba(palette.highlightBackgroundColor, Theme.opacityFaint)
                   : "transparent"
        })
        contentItem.radius = Theme.paddingSmall
        contentItem.anchors.left = Qt.binding(function() { return contentItem.parent.left })
        contentItem.anchors.right = Qt.binding(function() { return contentItem.parent.right })
        contentItem.anchors.leftMargin = Theme.horizontalPageMargin
        contentItem.anchors.rightMargin = Theme.horizontalPageMargin
    }
}
