/* -*- indent-tabs-mode: nil; js-indent-level: 2 -*- */
/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Copyright (c) 2022 Open Mobile Platform LLC.
 */

"use strict";

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cu = Components.utils;

const { XPCOMUtils } = ChromeUtils.import("resource://gre/modules/XPCOMUtils.jsm");

XPCOMUtils.defineLazyModuleGetter(this, "Services",
                                  "resource://gre/modules/Services.jsm");

Services.scriptloader.loadSubScript("chrome://embedlite/content/Logger.js");

function debug(...args)
{
  Logger.debug("JSComp: EmbedLiteMemoryShrink.js:", args);
}

function EmbedLiteMemoryShrink() {
}

EmbedLiteMemoryShrink.prototype = {
  classID: Components.ID("{dd412ae9-2efa-4267-8e61-2ba98c793106}"),
  QueryInterface: ChromeUtils.generateQI([Ci.nsIObserver]),

  tfast: Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer),
  _cleanerFast: function() {
    Services.obs.notifyObservers(null, "child-gc-request");
    debug("Fast clear called.");
  },

  tdeep: Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer),
  _cleanerDeep: function() {
    Services.obs.notifyObservers(null, "child-gc-request");
    Cu.forceGC();
    Services.obs.notifyObservers(null, "memory-pressure", "heap-minimize");
  },

  observe: function(aSubject, aTopic, aData) {
    debug("got " + aTopic)
    switch (aTopic) {
      case "app-startup":
        Services.obs.addObserver(this, "memory-pressure", false); // This is crucial because create reference to prevent unloading
        this.tfast.initWithCallback(this._cleanerFast, 10*1000, Ci.nsITimer.TYPE_REPEATING_SLACK);
        this.tdeep.initWithCallback(this._cleanerDeep, 45*1000, Ci.nsITimer.TYPE_REPEATING_SLACK);
        break;

      case "memory-pressure":
        debug("Deep clear called.");
        break;
    }
  }
};

this.NSGetFactory = XPCOMUtils.generateNSGetFactory([EmbedLiteMemoryShrink]);
