/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_TRUSTEDSOURCES_H
#define SAILFISH_MDM_TRUSTEDSOURCES_H

#include "mdm-trustedsources-types.h"

#include <QList>
#include <QObject>

namespace Sailfish {
namespace Mdm {

class TrustedSourcesPrivate;
class Q_DECL_EXPORT TrustedSources : public QObject
{
    Q_OBJECT

public:
    enum Result {
        Success = 0,
        InternalError,
        UnexistingSourceError,
        DatabaseError,
    };
    Q_ENUM(Result);

    explicit TrustedSources(QObject *parent = nullptr);

    Result getSourceSignatureRequired(bool &required);
    Result setSourceSignatureRequired(bool required);
    Result getSourceList(QList<TrustedSource> &sourceList);
    Result addSource(const QString &sourceKeyID, const QString &sourceSubject);
    Result removeSource(const QString &sourceKeyID);
    Result bindPackageToSource(const QString &packageID, const QString &sourceKeyID);
    Result unbindPackageFromSource(const QString &packageID);

signals:
    void sourceAdded(const TrustedSource &source);
    void sourceRemoved(const TrustedSource &source);
    void sourceChanged(const TrustedSource &source);
    void sourceSignatureRequiredChanged(bool required);

private:
    Q_DISABLE_COPY(TrustedSources)
    Q_DECLARE_PRIVATE(TrustedSources)

    TrustedSourcesPrivate *d_ptr;
};

} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_TRUSTEDSOURCES_H
