/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.0
import Aurora.Controls.private 1.0

PopupMenuBaseItem {
    id: subMenu

    default property alias items: menuPage.stackChildren
    property alias headerBackground: menuPage.headerBackground

    _secondaryIcon.source: "image://theme/icon-m-right"
    closeOnClick: false

    onClicked: {
        _parentPopup._pushPage(menuPage)
    }

    PopupPage {
        id: menuPage

        _parentPopup: subMenu._parentPopup
        headerText: text
        _isSubMenu: true
        parent: subMenu._parentPopup._pagesContainer ? subMenu._parentPopup._pagesContainer : subMenu._parentPopup
        visible: false
    }
}
