/**
 * SPDX-FileCopyrightText: Copyright 2020-2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_USERMANAGER_H
#define SAILFISH_MDM_USERMANAGER_H

#include <QObject>
#include <QScopedPointer>
#include <QString>

namespace Sailfish {
namespace Mdm {

class UserManagerPrivate;
class Q_DECL_EXPORT UserManager : public QObject
{
    Q_OBJECT

public:
    struct UserEntry
    {
        QString user;
        QString name;
        uint uid;
    };

    explicit UserManager(QObject *parent = 0);
    virtual ~UserManager();
    QList<UserEntry> users();
    uint addUser(const QString &userLogin);
    uint addUserWithParam(const QString &userLogin, const QString &userName, uint quota);
    uint addUserWithParam(const QString &userLogin,
                          const QString &userName,
                          uint quota,
                          bool percent);
    bool removeUser(uint uid);
    uint currentUser();
    QString currentUserUuid();
    bool setCurrentUser(uint uid);
    bool setNextSessionUser(uint uid);
    bool modifyUser(uint uid, const QString &newFullName);

    QString userUuid(uint uid);
    QStringList usersGroups(uint uid);
    bool addToGroups(uint uid, const QStringList &groups);
    bool removeFromGroups(uint uid, const QStringList &groups);

    QVariantMap getUserQuotaInfo();
    uint enableUserQuota(bool enable);

Q_SIGNALS:
    void userAdded(const UserEntry &user);
    void userAddFailed(const QString &error, const QString &message);

private:
    Q_DISABLE_COPY(UserManager)
    Q_DECLARE_PRIVATE(UserManager)

    QScopedPointer<UserManagerPrivate> d_ptr;
};
} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_USERMANAGER_H
