/****************************************************************************
**
** Copyright (c) 2021 - 2023 Open Mobile Platform LLC.
**
** License: Proprietary
**
****************************************************************************/
import QtQuick 2.6
import Sailfish.Silica 1.0

SilicaGridView {
    id: root

    property bool gridLayout
    property bool selectionEnabled
    property bool pasteMode
    property bool archiveMode
    property bool selectionMode
    property string description

    // Width of image background in FileItem
    readonly property real cellBackgroundSize: Theme.iconSizeMedium + Theme.paddingLarge * 2

    readonly property real contentCellWidthForLargeScreen: cellBackgroundSize + Theme.paddingLarge * 2 // Column width in FileItem
                                                           + Theme.paddingMedium * 2 // horizontal padding of Row in FileItem
                                                           + (selectionEnabled ? + Theme.itemSizeExtraSmall + Theme.paddingSmall : 0)  // horizontal padding of TextSwitch

    readonly property real chunkWidth: {
        var columns = Math.floor(width / contentCellWidthForLargeScreen)
        return (width - columns * contentCellWidthForLargeScreen) / columns
    }
    readonly property real cellWidthForLargeScreen: contentCellWidthForLargeScreen + chunkWidth

    readonly property real cellHeightForLargeScreen: cellBackgroundSize
                                                     + Theme.paddingSmall // spacing of Column in FileItem
                                                     + nameMetrics.height * 2 + sizeMetrics.height // height of Column in FileItem
                                                     + Theme.paddingSmall // spacing of Grid in FileItem
                                                     + Theme.paddingLarge  * 2 // vertical padding of Row in FileItem
    readonly property real cellHeightForSmallScreen: cellBackgroundSize
    property real cellWidthForSmallScreen

    cellHeight: gridLayout
                ? selectionEnabled ? cellHeightForLargeScreen + Theme.fontSizeExtraSmall : cellHeightForLargeScreen
                : cellHeightForSmallScreen

    cellWidth: gridLayout ? cellWidthForLargeScreen : cellWidthForSmallScreen

    currentIndex: -1
    displaced: Transition { NumberAnimation { properties: "x,y"; easing.type: Easing.InOutQuad; duration: 200 } }
    cacheBuffer: cellHeight * 4
    width: parent.width

    onContentHeightChanged: if (!!__silica_contextmenu_instance) __silica_contextmenu_instance.VerticalAutoScroll.fixup()

    Behavior on contentY {
        enabled: !gridLayout
        NumberAnimation { duration: 20 }
    }

    FontMetrics {
        id: nameMetrics
        // This value should be taken from nameLabel in FileItem when the screen is large
        font.pixelSize: Theme.fontSizeExtraSmall
    }
    FontMetrics {
        id: sizeMetrics
        // This value should be taken from sizeLabel in FileItem when the screen is large
        font.pixelSize: Theme.fontSizeTiny
    }
}
