/**
 * SPDX-FileCopyrightText: Copyright 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0
import Aurora.Controls 1.0

AppBar {
    id: root

    property var parentGridView
    property int buttonWidth
    property bool standardPath
    property bool isGalleryPreviewMode
    property bool _deletionProcessing
    property alias itemAnchorPopup: lastSpacer

    readonly property var model: parentGridView.model
    readonly property int selectedCount: model != null && model.selectedCount != null
                                         ? model.selectedCount
                                         : 0
    readonly property int selectedCountFolders: model != null && model.selectedCountFolders != null
                                                ? model.selectedCountFolders
                                                : 0
    signal pasteClicked()
    signal cancelClicked()
    signal extractClicked()
    signal shareClicked()
    signal copyClicked()
    signal deleteClicked()
    signal openMenuClicked()
    signal fullScreenModeClicked()

    AppBarButton {
        id: cancelButton

        visible: parentGridView.pasteMode || parentGridView.extractMode && !isGalleryPreviewMode
        //% "Cancel"
        text: qsTrId("filemanager-me-cancel")

        onClicked: cancelClicked()
    }

    AppBarSpacer {
        visible: parentGridView.pasteMode || parentGridView.extractMode
        width: parent.width - cancelButton.width - acceptButton.width
    }

    AppBarButton {
        id: acceptButton

        visible: parentGridView.pasteMode || parentGridView.extractMode
        enabled: !parentGridView.virtualFolder && !parentGridView.searchPage
                 && !standardPath && !isGalleryPreviewMode
        opacity: enabled ? 1.0 : Theme.opacityLow
        //% "Paste here"
        text: parentGridView.pasteMode ? qsTrId("filemanager-me-paste_here")
                                       : //% "Extract here"
                                         qsTrId("filemanager-me-extract_here")

        onClicked: parentGridView.pasteMode ? pasteClicked() : extractClicked()
    }

    AppBarSpacer {}

    AppBarButton {
        objectName: "ShareDockedItem"

        visible: !parentGridView.pasteMode && !parentGridView.extractMode
        enabled: (parentGridView.virtualFolder ||
                  (parentGridView.searchPage && !root.selectedCountFolders)
                  || root.selectedCountFolders === 0)
                 && (root.selectedCount > 0 || isGalleryPreviewMode) && !root._deletionProcessing
        icon.source: "image://theme/icon-splus-share"

        onClicked: shareClicked()
    }

    AppBarSpacer {}

    AppBarButton {
        objectName: "CopyDockedItem"

        visible: !parentGridView.pasteMode && !parentGridView.extractMode && !isGalleryPreviewMode
        enabled: root.selectedCount > 0 && !root._deletionProcessing
        icon.source: "image://theme/icon-splus-clipboard"

        onClicked: copyClicked()
    }

    AppBarSpacer {
        visible: !isGalleryPreviewMode
    }

    AppBarButton {
        objectName: "DeleteDockedItem"

        visible: !parentGridView.pasteMode && !parentGridView.extractMode
        enabled: !standardPath && (root.selectedCount > 0 || isGalleryPreviewMode) && !root._deletionProcessing
        icon.source: "image://theme/icon-splus-delete"

        onClicked: deleteClicked()
    }

    AppBarSpacer {
        visible: isGalleryPreviewMode
    }

    AppBarButton {
        objectName: "FullScreenPreviewDockedItem"

        visible: isGalleryPreviewMode
        icon.source: "image://theme/icon-splus-expand"

        onClicked: fullScreenModeClicked()
    }

    AppBarSpacer {}

    AppBarButton {
        id: buttonOpenPopup

        objectName: "OpenPopupItem"

        visible: !parentGridView.pasteMode && !parentGridView.extractMode
        icon.source: "image://theme/icon-splus-more"
        enabled: (root.selectedCount > 0 || isGalleryPreviewMode) && !root._deletionProcessing

        onClicked: openMenuClicked()
    }

    AppBarSpacer {
        id: lastSpacer
    }
}
