# This file was created by configpm when Perl was built. Any changes
# made to this file will be lost the next time perl is built.

package Config;
use strict;
use warnings;
use vars '%Config';

sub bincompat_options {
    return split ' ', (Internals::V())[0];
}

sub non_bincompat_options {
    return split ' ', (Internals::V())[1];
}

sub compile_date {
    return (Internals::V())[2]
}

sub local_patches {
    my (undef, undef, undef, @patches) = Internals::V();
    return @patches;
}

sub _V {
    my ($bincompat, $non_bincompat, $date, @patches) = Internals::V();

    my $opts = join ' ', sort split ' ', "$bincompat $non_bincompat";

    # wrap at 76 columns.

    $opts =~ s/(?=.{53})(.{1,53}) /$1\n                        /mg;

    print Config::myconfig();
    if ($^O eq 'VMS') {
        print "\nCharacteristics of this PERLSHR image: \n";
    } else {
        print "\nCharacteristics of this binary (from libperl): \n";
    }

    print "  Compile-time options: $opts\n";

    if (@patches) {
        print "  Locally applied patches:\n";
        print "\t$_\n" foreach @patches;
    }

    print "  Built under $^O\n";

    print "  $date\n" if defined $date;

    my @env = map { "$_=\"$ENV{$_}\"" } sort grep {/^PERL/} keys %ENV;
    push @env, "CYGWIN=\"$ENV{CYGWIN}\"" if $^O eq 'cygwin' and $ENV{CYGWIN};

    if (@env) {
        print "  \%ENV:\n";
        print "    $_\n" foreach @env;
    }
    print "  \@INC:\n";
    print "    $_\n" foreach @INC;
}

sub header_files {
    return qw(EXTERN.h INTERN.h XSUB.h av.h config.h cop.h cv.h
              dosish.h embed.h embedvar.h form.h gv.h handy.h hv.h intrpvar.h
              iperlsys.h keywords.h mg.h nostdio.h op.h opcode.h pad.h
              parser.h patchlevel.h perl.h perlio.h perliol.h perlsdio.h
              perlsfio.h perlvars.h perly.h pp.h pp_proto.h proto.h regcomp.h
              regexp.h regnodes.h scope.h sv.h thread.h time64.h unixish.h
              utf8.h util.h);
}

##
## This file was produced by running the Configure script. It holds all the
## definitions figured out by Configure. Should you modify one of these values,
## do not forget to propagate your changes by running "Configure -der". You may
## instead choose to run each of the .SH files by yourself, or "Configure -S".
##
#
## Package name      : perl5
## Source directory  : .
#
#: Configure command line arguments.
#
#: Variables propagated from previous config.sh file.

our $summary = <<'!END!';
Summary of my $package (revision $revision $version_patchlevel_string) configuration:
  $git_commit_id_title $git_commit_id$git_ancestor_line
  Platform:
    osname=$osname, osvers=$osvers, archname=$archname
    uname='$myuname'
    config_args='$config_args'
    hint=$hint, useposix=$useposix, d_sigaction=$d_sigaction
    useithreads=$useithreads, usemultiplicity=$usemultiplicity
    useperlio=$useperlio, d_sfio=$d_sfio, uselargefiles=$uselargefiles, usesocks=$usesocks
    use64bitint=$use64bitint, use64bitall=$use64bitall, uselongdouble=$uselongdouble
    usemymalloc=$usemymalloc, bincompat5005=undef
  Compiler:
    cc='$cc', ccflags ='$ccflags',
    optimize='$optimize',
    cppflags='$cppflags'
    ccversion='$ccversion', gccversion='$gccversion', gccosandvers='$gccosandvers'
    intsize=$intsize, longsize=$longsize, ptrsize=$ptrsize, doublesize=$doublesize, byteorder=$byteorder
    d_longlong=$d_longlong, longlongsize=$longlongsize, d_longdbl=$d_longdbl, longdblsize=$longdblsize
    ivtype='$ivtype', ivsize=$ivsize, nvtype='$nvtype', nvsize=$nvsize, Off_t='$lseektype', lseeksize=$lseeksize
    alignbytes=$alignbytes, prototype=$prototype
  Linker and Libraries:
    ld='$ld', ldflags ='$ldflags'
    libpth=$libpth
    libs=$libs
    perllibs=$perllibs
    libc=$libc, so=$so, useshrplib=$useshrplib, libperl=$libperl
    gnulibc_version='$gnulibc_version'
  Dynamic Linking:
    dlsrc=$dlsrc, dlext=$dlext, d_dlsymun=$d_dlsymun, ccdlflags='$ccdlflags'
    cccdlflags='$cccdlflags', lddlflags='$lddlflags'

!END!
my $summary_expanded;

sub myconfig {
    return $summary_expanded if $summary_expanded;
    ($summary_expanded = $summary) =~ s{\$(\w+)}
		 { 
			my $c;
			if ($1 eq 'git_ancestor_line') {
				if ($Config::Config{git_ancestor}) {
					$c= "\n  Ancestor: $Config::Config{git_ancestor}";
				} else {
					$c= "";
				}
			} else {
                     		$c = $Config::Config{$1}; 
			}
			defined($c) ? $c : 'undef' 
		}ge;
    $summary_expanded;
}

local *_ = \my $a;
$_ = <<'!END!';
Author=''
CONFIG='true'
Date='$Date'
Header=''
Id='$Id'
Locker=''
Log='$Log'
PATCHLEVEL='16'
PERL_API_REVISION='5'
PERL_API_SUBVERSION='0'
PERL_API_VERSION='16'
PERL_CONFIG_SH='true'
PERL_PATCHLEVEL=''
PERL_REVISION='5'
PERL_SUBVERSION='3'
PERL_VERSION='16'
RCSfile='$RCSfile'
Revision='$Revision'
SUBVERSION='3'
Source=''
State=''
_a='.a'
_exe=''
_o='.o'
afs='false'
afsroot='/afs'
alignbytes='8'
ansi2knr=''
aphostname=''
api_revision='5'
api_subversion='0'
api_version='16'
api_versionstring='5.16.0'
ar='ar'
archlib='/usr/lib64/perl5'
archlibexp='/usr/lib64/perl5'
archname64=''
archname='x86_64-linux-thread-multi'
archobjs=''
asctime_r_proto='REENTRANT_PROTO_B_SB'
awk='awk'
baserev='5.0'
bash=''
bin='/usr/bin'
bin_ELF='define'
binexp='/usr/bin'
bison='bison'
byacc='byacc'
byteorder='12345678'
c=''
castflags='0'
cat='cat'
cc='gcc'
cccdlflags='-fPIC'
ccdlflags='-Wl,--enable-new-dtags -Wl,-rpath,/usr/lib64/perl5/CORE'
ccflags='-D_REENTRANT -D_GNU_SOURCE -g -pipe -fexceptions --param=ssp-buffer-size=4 -O2 -Wp,-U_FORTIFY_SOURCE,-D_FORTIFY_SOURCE=2 -specs=/usr/lib/rpm/aurora/pie-pic-cc1 -fstack-protector-strong -Wall -Wformat -Wformat-security -m64 -mtune=generic -fpcc-struct-return -I/usr/local/include -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64'
ccflags_uselargefiles='-D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64'
ccname='gcc'
ccsymbols=''
ccversion=''
cf_by='Red Hat, Inc.'
cf_email='Red Hat, Inc.@localhost.localdomain'
charbits='8'
charsize='1'
chgrp=''
chmod='chmod'
chown=''
clocktype='clock_t'
comm='comm'
compress=''
config_arg0='Configure'
config_arg10='-Dcf_by=Red Hat, Inc.'
config_arg11='-Dprefix=/usr'
config_arg12='-Dvendorprefix=/usr'
config_arg13='-Dsiteprefix=/usr/local'
config_arg14='-Dsitelib=/usr/local/share/perl5'
config_arg15='-Dsitearch=/usr/local/lib64/perl5'
config_arg16='-Dprivlib=/usr/share/perl5'
config_arg17='-Dvendorlib=/usr/share/perl5/vendor_perl'
config_arg18='-Darchlib=/usr/lib64/perl5'
config_arg19='-Dvendorarch=/usr/lib64/perl5/vendor_perl'
config_arg1='-des'
config_arg20='-Darchname=x86_64-linux-thread-multi'
config_arg21='-Dlibpth=/usr/local/lib64 /lib /usr/lib /lib64 /usr/lib64'
config_arg22='-Duseshrplib'
config_arg23='-Dusethreads'
config_arg24='-Duseithreads'
config_arg25='-Duselargefiles'
config_arg26='-Dd_semctl_semun'
config_arg27='-Di_db'
config_arg28='-Di_shadow'
config_arg29='-Di_syslog'
config_arg2='-Doptimize=-g -pipe -fexceptions --param=ssp-buffer-size=4  -O2 -Wp,-U_FORTIFY_SOURCE,-D_FORTIFY_SOURCE=2 -specs=/usr/lib/rpm/aurora/pie-pic-cc1 -fstack-protector-strong -Wall -Wformat -Wformat-security  -m64 -mtune=generic'
config_arg30='-Dman1dir=/usr/share/man/man1'
config_arg31='-Dman3dir=/usr/share/man/man3'
config_arg32='-Dman3ext=3pm'
config_arg33='-Duseperlio'
config_arg34='-Dinstallusrbinperl=n'
config_arg35='-Ubincompat5005'
config_arg36='-Uversiononly'
config_arg37='-Dpager=/usr/bin/less -isr'
config_arg38='-Dd_gethostent_r_proto'
config_arg39='-Ud_endhostent_r_proto'
config_arg3='-Dccdlflags=-Wl,--enable-new-dtags'
config_arg40='-Ud_sethostent_r_proto'
config_arg41='-Ud_endprotoent_r_proto'
config_arg42='-Ud_setprotoent_r_proto'
config_arg43='-Ud_endservent_r_proto'
config_arg44='-Ud_setservent_r_proto'
config_arg45='-Dscriptdir=/usr/bin'
config_arg46='-Dusesitecustomize'
config_arg47='-Dccflags=-g -pipe -fexceptions --param=ssp-buffer-size=4  -O2 -Wp,-U_FORTIFY_SOURCE,-D_FORTIFY_SOURCE=2 -specs=/usr/lib/rpm/aurora/pie-pic-cc1 -fstack-protector-strong -Wall -Wformat -Wformat-security  -m64 -mtune=generic '
config_arg48='-Dldflags=-Wl,--as-needed -specs=/usr/lib/rpm/aurora/pie-pic-ld -Wl,-z,relro,-z,now '
config_arg4='-Dlddlflags=-shared -g -pipe -fexceptions --param=ssp-buffer-size=4  -O2 -Wp,-U_FORTIFY_SOURCE,-D_FORTIFY_SOURCE=2 -specs=/usr/lib/rpm/aurora/pie-pic-cc1 -fstack-protector-strong -Wall -Wformat -Wformat-security  -m64 -mtune=generic '
config_arg5='-DDEBUGGING=-g'
config_arg6='-Dversion=5.16.3'
config_arg7='-Dmyhostname=localhost'
config_arg8='-Dperladmin=root@localhost'
config_arg9='-Dcc=gcc'
config_argc='48'
config_args='-des -Doptimize=-g -pipe -fexceptions --param=ssp-buffer-size=4  -O2 -Wp,-U_FORTIFY_SOURCE,-D_FORTIFY_SOURCE=2 -specs=/usr/lib/rpm/aurora/pie-pic-cc1 -fstack-protector-strong -Wall -Wformat -Wformat-security  -m64 -mtune=generic -Dccdlflags=-Wl,--enable-new-dtags -Dlddlflags=-shared -g -pipe -fexceptions --param=ssp-buffer-size=4  -O2 -Wp,-U_FORTIFY_SOURCE,-D_FORTIFY_SOURCE=2 -specs=/usr/lib/rpm/aurora/pie-pic-cc1 -fstack-protector-strong -Wall -Wformat -Wformat-security  -m64 -mtune=generic  -DDEBUGGING=-g -Dversion=5.16.3 -Dmyhostname=localhost -Dperladmin=root@localhost -Dcc=gcc -Dcf_by=Red Hat, Inc. -Dprefix=/usr -Dvendorprefix=/usr -Dsiteprefix=/usr/local -Dsitelib=/usr/local/share/perl5 -Dsitearch=/usr/local/lib64/perl5 -Dprivlib=/usr/share/perl5 -Dvendorlib=/usr/share/perl5/vendor_perl -Darchlib=/usr/lib64/perl5 -Dvendorarch=/usr/lib64/perl5/vendor_perl -Darchname=x86_64-linux-thread-multi -Dlibpth=/usr/local/lib64 /lib /usr/lib /lib64 /usr/lib64 -Duseshrplib -Dusethreads -Duseithreads -Duselargefiles -Dd_semctl_semun -Di_db -Di_shadow -Di_syslog -Dman1dir=/usr/share/man/man1 -Dman3dir=/usr/share/man/man3 -Dman3ext=3pm -Duseperlio -Dinstallusrbinperl=n -Ubincompat5005 -Uversiononly -Dpager=/usr/bin/less -isr -Dd_gethostent_r_proto -Ud_endhostent_r_proto -Ud_sethostent_r_proto -Ud_endprotoent_r_proto -Ud_setprotoent_r_proto -Ud_endservent_r_proto -Ud_setservent_r_proto -Dscriptdir=/usr/bin -Dusesitecustomize -Dccflags=-g -pipe -fexceptions --param=ssp-buffer-size=4  -O2 -Wp,-U_FORTIFY_SOURCE,-D_FORTIFY_SOURCE=2 -specs=/usr/lib/rpm/aurora/pie-pic-cc1 -fstack-protector-strong -Wall -Wformat -Wformat-security  -m64 -mtune=generic  -Dldflags=-Wl,--as-needed -specs=/usr/lib/rpm/aurora/pie-pic-ld -Wl,-z,relro,-z,now '
contains='grep'
cp='cp'
cpio=''
cpp='cpp'
cpp_stuff='42'
cppccsymbols=''
cppflags='-D_REENTRANT -D_GNU_SOURCE -g -pipe -fexceptions --param=ssp-buffer-size=4 -O2 -Wp,-U_FORTIFY_SOURCE,-D_FORTIFY_SOURCE=2 -specs=/usr/lib/rpm/aurora/pie-pic-cc1 -fstack-protector-strong -Wall -Wformat -Wformat-security -m64 -mtune=generic -fpcc-struct-return -I/usr/local/include -D__GNUC__'
cpplast='-'
cppminus='-'
cpprun='gcc -E'
cppstdin='gcc -E'
cppsymbols='_FILE_OFFSET_BITS=64 _GNU_SOURCE=1 _LARGEFILE64_SOURCE=1 _LARGEFILE_SOURCE=1 _LP64=1 _POSIX_C_SOURCE=200809L _POSIX_SOURCE=1 _REENTRANT=1 _STDC_PREDEF_H=1 _XOPEN_SOURCE=700 _XOPEN_SOURCE_EXTENDED=1 __ATOMIC_ACQUIRE=2 __ATOMIC_ACQ_REL=4 __ATOMIC_CONSUME=1 __ATOMIC_HLE_ACQUIRE=65536 __ATOMIC_HLE_RELEASE=131072 __ATOMIC_RELAXED=0 __ATOMIC_RELEASE=3 __ATOMIC_SEQ_CST=5 __BIGGEST_ALIGNMENT__=16 __BYTE_ORDER__=1234 __CHAR16_TYPE__=short\ unsigned\ int __CHAR32_TYPE__=unsigned\ int __CHAR_BIT__=8 __DBL_DECIMAL_DIG__=17 __DBL_DENORM_MIN__=((double)4.94065645841246544176568792868221372e-324L) __DBL_DIG__=15 __DBL_EPSILON__=((double)2.22044604925031308084726333618164062e-16L) __DBL_HAS_DENORM__=1 __DBL_HAS_INFINITY__=1 __DBL_HAS_QUIET_NAN__=1 __DBL_IS_IEC_60559__=2 __DBL_MANT_DIG__=53 __DBL_MAX_10_EXP__=308 __DBL_MAX_EXP__=1024 __DBL_MAX__=((double)1.79769313486231570814527423731704357e+308L) __DBL_MIN_10_EXP__=(-307) __DBL_MIN_EXP__=(-1021) __DBL_MIN__=((double)2.22507385850720138309023271733240406e-308L) __DBL_NORM_MAX__=((double)1.79769313486231570814527423731704357e+308L) __DEC128_EPSILON__=1E-33DL __DEC128_MANT_DIG__=34 __DEC128_MAX_EXP__=6145 __DEC128_MAX__=9.999999999999999999999999999999999E6144DL __DEC128_MIN_EXP__=(-6142) __DEC128_MIN__=1E-6143DL __DEC128_SUBNORMAL_MIN__=0.000000000000000000000000000000001E-6143DL __DEC32_EPSILON__=1E-6DF __DEC32_MANT_DIG__=7 __DEC32_MAX_EXP__=97 __DEC32_MAX__=9.999999E96DF __DEC32_MIN_EXP__=(-94) __DEC32_MIN__=1E-95DF __DEC32_SUBNORMAL_MIN__=0.000001E-95DF __DEC64_EPSILON__=1E-15DD __DEC64_MANT_DIG__=16 __DEC64_MAX_EXP__=385 __DEC64_MAX__=9.999999999999999E384DD __DEC64_MIN_EXP__=(-382) __DEC64_MIN__=1E-383DD __DEC64_SUBNORMAL_MIN__=0.000000000000001E-383DD __DECIMAL_BID_FORMAT__=1 __DECIMAL_DIG__=21 __DEC_EVAL_METHOD__=2 __ELF__=1 __FINITE_MATH_ONLY__=0 __FLOAT_WORD_ORDER__=1234 __FLT128_DECIMAL_DIG__=36 __FLT128_DENORM_MIN__=6.47517511943802511092443895822764655e-4966F128 __FLT128_DIG__=33 __FLT128_EPSILON__=1.92592994438723585305597794258492732e-34F128 __FLT128_HAS_DENORM__=1 __FLT128_HAS_INFINITY__=1 __FLT128_HAS_QUIET_NAN__=1 __FLT128_IS_IEC_60559__=2 __FLT128_MANT_DIG__=113 __FLT128_MAX_10_EXP__=4932 __FLT128_MAX_EXP__=16384 __FLT128_MAX__=1.18973149535723176508575932662800702e+4932F128 __FLT128_MIN_10_EXP__=(-4931) __FLT128_MIN_EXP__=(-16381) __FLT128_MIN__=3.36210314311209350626267781732175260e-4932F128 __FLT128_NORM_MAX__=1.18973149535723176508575932662800702e+4932F128 __FLT16_DECIMAL_DIG__=5 __FLT16_DENORM_MIN__=5.96046447753906250000000000000000000e-8F16 __FLT16_DIG__=3 __FLT16_EPSILON__=9.76562500000000000000000000000000000e-4F16 __FLT16_HAS_DENORM__=1 __FLT16_HAS_INFINITY__=1 __FLT16_HAS_QUIET_NAN__=1 __FLT16_IS_IEC_60559__=2 __FLT16_MANT_DIG__=11 __FLT16_MAX_10_EXP__=4 __FLT16_MAX_EXP__=16 __FLT16_MAX__=6.55040000000000000000000000000000000e+4F16 __FLT16_MIN_10_EXP__=(-4) __FLT16_MIN_EXP__=(-13) __FLT16_MIN__=6.10351562500000000000000000000000000e-5F16 __FLT16_NORM_MAX__=6.55040000000000000000000000000000000e+4F16 __FLT32X_DECIMAL_DIG__=17 __FLT32X_DENORM_MIN__=4.94065645841246544176568792868221372e-324F32x __FLT32X_DIG__=15 __FLT32X_EPSILON__=2.22044604925031308084726333618164062e-16F32x __FLT32X_HAS_DENORM__=1 __FLT32X_HAS_INFINITY__=1 __FLT32X_HAS_QUIET_NAN__=1 __FLT32X_IS_IEC_60559__=2 __FLT32X_MANT_DIG__=53 __FLT32X_MAX_10_EXP__=308 __FLT32X_MAX_EXP__=1024 __FLT32X_MAX__=1.79769313486231570814527423731704357e+308F32x __FLT32X_MIN_10_EXP__=(-307) __FLT32X_MIN_EXP__=(-1021) __FLT32X_MIN__=2.22507385850720138309023271733240406e-308F32x __FLT32X_NORM_MAX__=1.79769313486231570814527423731704357e+308F32x __FLT32_DECIMAL_DIG__=9 __FLT32_DENORM_MIN__=1.40129846432481707092372958328991613e-45F32 __FLT32_DIG__=6 __FLT32_EPSILON__=1.19209289550781250000000000000000000e-7F32 __FLT32_HAS_DENORM__=1 __FLT32_HAS_INFINITY__=1 __FLT32_HAS_QUIET_NAN__=1 __FLT32_IS_IEC_60559__=2 __FLT32_MANT_DIG__=24 __FLT32_MAX_10_EXP__=38 __FLT32_MAX_EXP__=128 __FLT32_MAX__=3.40282346638528859811704183484516925e+38F32 __FLT32_MIN_10_EXP__=(-37) __FLT32_MIN_EXP__=(-125) __FLT32_MIN__=1.17549435082228750796873653722224568e-38F32 __FLT32_NORM_MAX__=3.40282346638528859811704183484516925e+38F32 __FLT64X_DECIMAL_DIG__=21 __FLT64X_DENORM_MIN__=3.64519953188247460252840593361941982e-4951F64x __FLT64X_DIG__=18 __FLT64X_EPSILON__=1.08420217248550443400745280086994171e-19F64x __FLT64X_HAS_DENORM__=1 __FLT64X_HAS_INFINITY__=1 __FLT64X_HAS_QUIET_NAN__=1 __FLT64X_IS_IEC_60559__=2 __FLT64X_MANT_DIG__=64 __FLT64X_MAX_10_EXP__=4932 __FLT64X_MAX_EXP__=16384 __FLT64X_MAX__=1.18973149535723176502126385303097021e+4932F64x __FLT64X_MIN_10_EXP__=(-4931) __FLT64X_MIN_EXP__=(-16381) __FLT64X_MIN__=3.36210314311209350626267781732175260e-4932F64x __FLT64X_NORM_MAX__=1.18973149535723176502126385303097021e+4932F64x __FLT64_DECIMAL_DIG__=17 __FLT64_DENORM_MIN__=4.94065645841246544176568792868221372e-324F64 __FLT64_DIG__=15 __FLT64_EPSILON__=2.22044604925031308084726333618164062e-16F64 __FLT64_HAS_DENORM__=1 __FLT64_HAS_INFINITY__=1 __FLT64_HAS_QUIET_NAN__=1 __FLT64_IS_IEC_60559__=2 __FLT64_MANT_DIG__=53 __FLT64_MAX_10_EXP__=308 __FLT64_MAX_EXP__=1024 __FLT64_MAX__=1.79769313486231570814527423731704357e+308F64 __FLT64_MIN_10_EXP__=(-307) __FLT64_MIN_EXP__=(-1021) __FLT64_MIN__=2.22507385850720138309023271733240406e-308F64 __FLT64_NORM_MAX__=1.79769313486231570814527423731704357e+308F64 __FLT_DECIMAL_DIG__=9 __FLT_DENORM_MIN__=1.40129846432481707092372958328991613e-45F __FLT_DIG__=6 __FLT_EPSILON__=1.19209289550781250000000000000000000e-7F __FLT_EVAL_METHOD_TS_18661_3__=0 __FLT_EVAL_METHOD__=0 __FLT_HAS_DENORM__=1 __FLT_HAS_INFINITY__=1 __FLT_HAS_QUIET_NAN__=1 __FLT_IS_IEC_60559__=2 __FLT_MANT_DIG__=24 __FLT_MAX_10_EXP__=38 __FLT_MAX_EXP__=128 __FLT_MAX__=3.40282346638528859811704183484516925e+38F __FLT_MIN_10_EXP__=(-37) __FLT_MIN_EXP__=(-125) __FLT_MIN__=1.17549435082228750796873653722224568e-38F __FLT_NORM_MAX__=3.40282346638528859811704183484516925e+38F __FLT_RADIX__=2 __FXSR__=1 __GCC_ASM_FLAG_OUTPUTS__=1 __GCC_ATOMIC_BOOL_LOCK_FREE=2 __GCC_ATOMIC_CHAR16_T_LOCK_FREE=2 __GCC_ATOMIC_CHAR32_T_LOCK_FREE=2 __GCC_ATOMIC_CHAR_LOCK_FREE=2 __GCC_ATOMIC_INT_LOCK_FREE=2 __GCC_ATOMIC_LLONG_LOCK_FREE=2 __GCC_ATOMIC_LONG_LOCK_FREE=2 __GCC_ATOMIC_POINTER_LOCK_FREE=2 __GCC_ATOMIC_SHORT_LOCK_FREE=2 __GCC_ATOMIC_TEST_AND_SET_TRUEVAL=1 __GCC_ATOMIC_WCHAR_T_LOCK_FREE=2 __GCC_CONSTRUCTIVE_SIZE=64 __GCC_DESTRUCTIVE_SIZE=64 __GCC_HAVE_DWARF2_CFI_ASM=1 __GCC_HAVE_SYNC_COMPARE_AND_SWAP_1=1 __GCC_HAVE_SYNC_COMPARE_AND_SWAP_2=1 __GCC_HAVE_SYNC_COMPARE_AND_SWAP_4=1 __GCC_HAVE_SYNC_COMPARE_AND_SWAP_8=1 __GCC_IEC_559=2 __GCC_IEC_559_COMPLEX=2 __GLIBC_MINOR__=38 __GLIBC__=2 __GNUC_EXECUTION_CHARSET_NAME="UTF-8" __GNUC_MINOR__=3 __GNUC_PATCHLEVEL__=1 __GNUC_STDC_INLINE__=1 __GNUC_WIDE_EXECUTION_CHARSET_NAME="UTF-32LE" __GNUC__=12 __GNU_LIBRARY__=6 __GXX_ABI_VERSION=1017 __HAVE_SPECULATION_SAFE_VALUE=1 __INT16_C(c)=c __INT16_MAX__=0x7fff __INT16_TYPE__=short\ int __INT32_C(c)=c __INT32_MAX__=0x7fffffff __INT32_TYPE__=int __INT64_C(c)=cL __INT64_MAX__=0x7fffffffffffffffL __INT64_TYPE__=long\ int __INT8_C(c)=c __INT8_MAX__=0x7f __INT8_TYPE__=signed\ char __INTMAX_C(c)=cL __INTMAX_MAX__=0x7fffffffffffffffL __INTMAX_TYPE__=long\ int __INTMAX_WIDTH__=64 __INTPTR_MAX__=0x7fffffffffffffffL __INTPTR_TYPE__=long\ int __INTPTR_WIDTH__=64 __INT_FAST16_MAX__=0x7fffffffffffffffL __INT_FAST16_TYPE__=long\ int __INT_FAST16_WIDTH__=64 __INT_FAST32_MAX__=0x7fffffffffffffffL __INT_FAST32_TYPE__=long\ int __INT_FAST32_WIDTH__=64 __INT_FAST64_MAX__=0x7fffffffffffffffL __INT_FAST64_TYPE__=long\ int __INT_FAST64_WIDTH__=64 __INT_FAST8_MAX__=0x7f __INT_FAST8_TYPE__=signed\ char __INT_FAST8_WIDTH__=8 __INT_LEAST16_MAX__=0x7fff __INT_LEAST16_TYPE__=short\ int __INT_LEAST16_WIDTH__=16 __INT_LEAST32_MAX__=0x7fffffff __INT_LEAST32_TYPE__=int __INT_LEAST32_WIDTH__=32 __INT_LEAST64_MAX__=0x7fffffffffffffffL __INT_LEAST64_TYPE__=long\ int __INT_LEAST64_WIDTH__=64 __INT_LEAST8_MAX__=0x7f __INT_LEAST8_TYPE__=signed\ char __INT_LEAST8_WIDTH__=8 __INT_MAX__=0x7fffffff __INT_WIDTH__=32 __LDBL_DECIMAL_DIG__=21 __LDBL_DENORM_MIN__=3.64519953188247460252840593361941982e-4951L __LDBL_DIG__=18 __LDBL_EPSILON__=1.08420217248550443400745280086994171e-19L __LDBL_HAS_DENORM__=1 __LDBL_HAS_INFINITY__=1 __LDBL_HAS_QUIET_NAN__=1 __LDBL_IS_IEC_60559__=2 __LDBL_MANT_DIG__=64 __LDBL_MAX_10_EXP__=4932 __LDBL_MAX_EXP__=16384 __LDBL_MAX__=1.18973149535723176502126385303097021e+4932L __LDBL_MIN_10_EXP__=(-4931) __LDBL_MIN_EXP__=(-16381) __LDBL_MIN__=3.36210314311209350626267781732175260e-4932L __LDBL_NORM_MAX__=1.18973149535723176502126385303097021e+4932L __LONG_LONG_MAX__=0x7fffffffffffffffLL __LONG_LONG_WIDTH__=64 __LONG_MAX__=0x7fffffffffffffffL __LONG_WIDTH__=64 __LP64__=1 __MMX_WITH_SSE__=1 __MMX__=1 __ORDER_BIG_ENDIAN__=4321 __ORDER_LITTLE_ENDIAN__=1234 __ORDER_PDP_ENDIAN__=3412 __PIC__=2 __PIE__=2 __PRAGMA_REDEFINE_EXTNAME=1 __PTRDIFF_MAX__=0x7fffffffffffffffL __PTRDIFF_TYPE__=long\ int __PTRDIFF_WIDTH__=64 __REGISTER_PREFIX__= __SCHAR_MAX__=0x7f __SCHAR_WIDTH__=8 __SEG_FS=1 __SEG_GS=1 __SHRT_MAX__=0x7fff __SHRT_WIDTH__=16 __SIG_ATOMIC_MAX__=0x7fffffff __SIG_ATOMIC_MIN__=(-0x7fffffff\ -\ 1) __SIG_ATOMIC_TYPE__=int __SIG_ATOMIC_WIDTH__=32 __SIZEOF_DOUBLE__=8 __SIZEOF_FLOAT128__=16 __SIZEOF_FLOAT80__=16 __SIZEOF_FLOAT__=4 __SIZEOF_INT128__=16 __SIZEOF_INT__=4 __SIZEOF_LONG_DOUBLE__=16 __SIZEOF_LONG_LONG__=8 __SIZEOF_LONG__=8 __SIZEOF_POINTER__=8 __SIZEOF_PTRDIFF_T__=8 __SIZEOF_SHORT__=2 __SIZEOF_SIZE_T__=8 __SIZEOF_WCHAR_T__=4 __SIZEOF_WINT_T__=4 __SIZE_MAX__=0xffffffffffffffffUL __SIZE_TYPE__=long\ unsigned\ int __SIZE_WIDTH__=64 __SSE2_MATH__=1 __SSE2__=1 __SSE_MATH__=1 __SSE__=1 __STDC_HOSTED__=1 __STDC_IEC_559_COMPLEX__=1 __STDC_IEC_559__=1 __STDC_IEC_60559_BFP__=201404L __STDC_IEC_60559_COMPLEX__=201404L __STDC_ISO_10646__=201706L __STDC_UTF_16__=1 __STDC_UTF_32__=1 __STDC_VERSION__=201710L __STDC__=1 __UINT16_C(c)=c __UINT16_MAX__=0xffff __UINT16_TYPE__=short\ unsigned\ int __UINT32_C(c)=cU __UINT32_MAX__=0xffffffffU __UINT32_TYPE__=unsigned\ int __UINT64_C(c)=cUL __UINT64_MAX__=0xffffffffffffffffUL __UINT64_TYPE__=long\ unsigned\ int __UINT8_C(c)=c __UINT8_MAX__=0xff __UINT8_TYPE__=unsigned\ char __UINTMAX_C(c)=cUL __UINTMAX_MAX__=0xffffffffffffffffUL __UINTMAX_TYPE__=long\ unsigned\ int __UINTPTR_MAX__=0xffffffffffffffffUL __UINTPTR_TYPE__=long\ unsigned\ int __UINT_FAST16_MAX__=0xffffffffffffffffUL __UINT_FAST16_TYPE__=long\ unsigned\ int __UINT_FAST32_MAX__=0xffffffffffffffffUL __UINT_FAST32_TYPE__=long\ unsigned\ int __UINT_FAST64_MAX__=0xffffffffffffffffUL __UINT_FAST64_TYPE__=long\ unsigned\ int __UINT_FAST8_MAX__=0xff __UINT_FAST8_TYPE__=unsigned\ char __UINT_LEAST16_MAX__=0xffff __UINT_LEAST16_TYPE__=short\ unsigned\ int __UINT_LEAST32_MAX__=0xffffffffU __UINT_LEAST32_TYPE__=unsigned\ int __UINT_LEAST64_MAX__=0xffffffffffffffffUL __UINT_LEAST64_TYPE__=long\ unsigned\ int __UINT_LEAST8_MAX__=0xff __UINT_LEAST8_TYPE__=unsigned\ char __USER_LABEL_PREFIX__= __USE_FILE_OFFSET64=1 __USE_GNU=1 __USE_LARGEFILE64=1 __USE_LARGEFILE=1 __USE_MISC=1 __USE_POSIX199309=1 __USE_POSIX199506=1 __USE_POSIX2=1 __USE_POSIX=1 __USE_UNIX98=1 __USE_XOPEN=1 __USE_XOPEN_EXTENDED=1 __VERSION__="12.3.1\ 20230626\ (Aurora\ OS\ gcc\ 12.3.1+git2-1.4.2.omp)" __WCHAR_MAX__=0x7fffffff __WCHAR_MIN__=(-0x7fffffff\ -\ 1) __WCHAR_TYPE__=int __WCHAR_WIDTH__=32 __WINT_MAX__=0xffffffffU __WINT_MIN__=0U __WINT_TYPE__=unsigned\ int __WINT_WIDTH__=32 __amd64=1 __amd64__=1 __code_model_small__=1 __gnu_linux__=1 __k8=1 __k8__=1 __linux=1 __linux__=1 __pic__=2 __pie__=2 __unix=1 __unix__=1 __x86_64=1 __x86_64__=1 linux=1 unix=1'
crypt_r_proto='REENTRANT_PROTO_B_CCS'
cryptlib=''
csh='csh'
ctermid_r_proto='0'
ctime_r_proto='REENTRANT_PROTO_B_SB'
d_Gconvert='gcvt((x),(n),(b))'
d_PRIEUldbl='define'
d_PRIFUldbl='define'
d_PRIGUldbl='define'
d_PRIXU64='define'
d_PRId64='define'
d_PRIeldbl='define'
d_PRIfldbl='define'
d_PRIgldbl='define'
d_PRIi64='define'
d_PRIo64='define'
d_PRIu64='define'
d_PRIx64='define'
d_SCNfldbl='define'
d__fwalk='undef'
d_access='define'
d_accessx='undef'
d_aintl='undef'
d_alarm='define'
d_archlib='define'
d_asctime64='undef'
d_asctime_r='define'
d_atolf='undef'
d_atoll='define'
d_attribute_deprecated='define'
d_attribute_format='define'
d_attribute_malloc='define'
d_attribute_nonnull='define'
d_attribute_noreturn='define'
d_attribute_pure='define'
d_attribute_unused='define'
d_attribute_warn_unused_result='define'
d_bcmp='define'
d_bcopy='define'
d_bsd='undef'
d_bsdgetpgrp='undef'
d_bsdsetpgrp='undef'
d_builtin_choose_expr='define'
d_builtin_expect='define'
d_bzero='define'
d_c99_variadic_macros='define'
d_casti32='undef'
d_castneg='define'
d_charvspr='undef'
d_chown='define'
d_chroot='define'
d_chsize='undef'
d_class='undef'
d_clearenv='define'
d_closedir='define'
d_cmsghdr_s='define'
d_const='define'
d_copysignl='define'
d_cplusplus='undef'
d_crypt='define'
d_crypt_r='define'
d_csh='undef'
d_ctermid='define'
d_ctermid_r='undef'
d_ctime64='undef'
d_ctime_r='define'
d_cuserid='define'
d_dbl_dig='define'
d_dbminitproto='undef'
d_difftime64='undef'
d_difftime='define'
d_dir_dd_fd='undef'
d_dirfd='define'
d_dirnamlen='undef'
d_dlerror='define'
d_dlopen='define'
d_dlsymun='undef'
d_dosuid='undef'
d_drand48_r='define'
d_drand48proto='define'
d_dup2='define'
d_eaccess='define'
d_endgrent='define'
d_endgrent_r='undef'
d_endhent='define'
d_endhostent_r='undef'
d_endnent='define'
d_endnetent_r='undef'
d_endpent='define'
d_endprotoent_r='undef'
d_endpwent='define'
d_endpwent_r='undef'
d_endsent='define'
d_endservent_r='undef'
d_eofnblk='define'
d_eunice='undef'
d_faststdio='undef'
d_fchdir='define'
d_fchmod='define'
d_fchown='define'
d_fcntl='define'
d_fcntl_can_lock='define'
d_fd_macros='define'
d_fd_set='define'
d_fds_bits='define'
d_fgetpos='define'
d_finite='define'
d_finitel='define'
d_flexfnam='define'
d_flock='define'
d_flockproto='define'
d_fork='define'
d_fp_class='undef'
d_fpathconf='define'
d_fpclass='undef'
d_fpclassify='undef'
d_fpclassl='undef'
d_fpos64_t='undef'
d_frexpl='define'
d_fs_data_s='undef'
d_fseeko='define'
d_fsetpos='define'
d_fstatfs='define'
d_fstatvfs='define'
d_fsync='define'
d_ftello='define'
d_ftime='undef'
d_futimes='define'
d_gdbm_ndbm_h_uses_prototypes='undef'
d_gdbmndbm_h_uses_prototypes='undef'
d_getaddrinfo='define'
d_getcwd='define'
d_getespwnam='undef'
d_getfsstat='undef'
d_getgrent='define'
d_getgrent_r='define'
d_getgrgid_r='define'
d_getgrnam_r='define'
d_getgrps='define'
d_gethbyaddr='define'
d_gethbyname='define'
d_gethent='define'
d_gethname='define'
d_gethostbyaddr_r='define'
d_gethostbyname_r='define'
d_gethostent_r='define'
d_gethostprotos='define'
d_getitimer='define'
d_getlogin='define'
d_getlogin_r='define'
d_getmnt='undef'
d_getmntent='define'
d_getnameinfo='define'
d_getnbyaddr='define'
d_getnbyname='define'
d_getnent='define'
d_getnetbyaddr_r='define'
d_getnetbyname_r='define'
d_getnetent_r='define'
d_getnetprotos='define'
d_getpagsz='define'
d_getpbyname='define'
d_getpbynumber='define'
d_getpent='define'
d_getpgid='define'
d_getpgrp2='undef'
d_getpgrp='define'
d_getppid='define'
d_getprior='define'
d_getprotobyname_r='define'
d_getprotobynumber_r='define'
d_getprotoent_r='define'
d_getprotoprotos='define'
d_getprpwnam='undef'
d_getpwent='define'
d_getpwent_r='define'
d_getpwnam_r='define'
d_getpwuid_r='define'
d_getsbyname='define'
d_getsbyport='define'
d_getsent='define'
d_getservbyname_r='define'
d_getservbyport_r='define'
d_getservent_r='define'
d_getservprotos='define'
d_getspnam='define'
d_getspnam_r='define'
d_gettimeod='define'
d_gmtime64='undef'
d_gmtime_r='define'
d_gnulibc='define'
d_grpasswd='define'
d_hasmntopt='define'
d_htonl='define'
d_ilogbl='define'
d_inc_version_list='undef'
d_index='undef'
d_inetaton='define'
d_inetntop='define'
d_inetpton='define'
d_int64_t='define'
d_ipv6_mreq='define'
d_isascii='define'
d_isblank='define'
d_isfinite='undef'
d_isinf='define'
d_isnan='define'
d_isnanl='define'
d_killpg='define'
d_lchown='define'
d_ldbl_dig='define'
d_libm_lib_version='undef'
d_link='define'
d_localtime64='undef'
d_localtime_r='define'
d_localtime_r_needs_tzset='define'
d_locconv='define'
d_lockf='define'
d_longdbl='define'
d_longlong='define'
d_lseekproto='define'
d_lstat='define'
d_madvise='define'
d_malloc_good_size='undef'
d_malloc_size='undef'
d_mblen='define'
d_mbstowcs='define'
d_mbtowc='define'
d_memchr='define'
d_memcmp='define'
d_memcpy='define'
d_memmove='define'
d_memset='define'
d_mkdir='define'
d_mkdtemp='define'
d_mkfifo='define'
d_mkstemp='define'
d_mkstemps='define'
d_mktime64='undef'
d_mktime='define'
d_mmap='define'
d_modfl='define'
d_modfl_pow32_bug='undef'
d_modflproto='define'
d_mprotect='define'
d_msg='define'
d_msg_ctrunc='define'
d_msg_dontroute='define'
d_msg_oob='define'
d_msg_peek='define'
d_msg_proxy='define'
d_msgctl='define'
d_msgget='define'
d_msghdr_s='define'
d_msgrcv='define'
d_msgsnd='define'
d_msync='define'
d_munmap='define'
d_mymalloc='undef'
d_ndbm='undef'
d_ndbm_h_uses_prototypes='undef'
d_nice='define'
d_nl_langinfo='define'
d_nv_preserves_uv='undef'
d_nv_zero_is_allbits_zero='define'
d_off64_t='define'
d_old_pthread_create_joinable='undef'
d_oldpthreads='undef'
d_oldsock='undef'
d_open3='define'
d_pathconf='define'
d_pause='define'
d_perl_otherlibdirs='undef'
d_phostname='undef'
d_pipe='define'
d_poll='define'
d_portable='define'
d_prctl='define'
d_prctl_set_name='define'
d_printf_format_null='undef'
d_procselfexe='define'
d_pseudofork='undef'
d_pthread_atfork='define'
d_pthread_attr_setscope='define'
d_pthread_yield='define'
d_pwage='undef'
d_pwchange='undef'
d_pwclass='undef'
d_pwcomment='undef'
d_pwexpire='undef'
d_pwgecos='define'
d_pwpasswd='define'
d_pwquota='undef'
d_qgcvt='define'
d_quad='define'
d_random_r='define'
d_readdir64_r='define'
d_readdir='define'
d_readdir_r='define'
d_readlink='define'
d_readv='define'
d_recvmsg='define'
d_rename='define'
d_rewinddir='define'
d_rmdir='define'
d_safebcpy='undef'
d_safemcpy='undef'
d_sanemcmp='define'
d_sbrkproto='define'
d_scalbnl='define'
d_sched_yield='define'
d_scm_rights='define'
d_seekdir='define'
d_select='define'
d_sem='define'
d_semctl='define'
d_semctl_semid_ds='define'
d_semctl_semun='define'
d_semget='define'
d_semop='define'
d_sendmsg='define'
d_setegid='define'
d_seteuid='define'
d_setgrent='define'
d_setgrent_r='undef'
d_setgrps='define'
d_sethent='define'
d_sethostent_r='undef'
d_setitimer='define'
d_setlinebuf='define'
d_setlocale='define'
d_setlocale_r='undef'
d_setnent='define'
d_setnetent_r='undef'
d_setpent='define'
d_setpgid='define'
d_setpgrp2='undef'
d_setpgrp='define'
d_setprior='define'
d_setproctitle='undef'
d_setprotoent_r='undef'
d_setpwent='define'
d_setpwent_r='undef'
d_setregid='define'
d_setresgid='define'
d_setresuid='define'
d_setreuid='define'
d_setrgid='undef'
d_setruid='undef'
d_setsent='define'
d_setservent_r='undef'
d_setsid='define'
d_setvbuf='define'
d_sfio='undef'
d_shm='define'
d_shmat='define'
d_shmatprototype='define'
d_shmctl='define'
d_shmdt='define'
d_shmget='define'
d_sigaction='define'
d_signbit='define'
d_sigprocmask='define'
d_sigsetjmp='define'
d_sin6_scope_id='define'
d_sitearch='define'
d_snprintf='define'
d_sockaddr_in6='define'
d_sockaddr_sa_len='undef'
d_sockatmark='define'
d_sockatmarkproto='define'
d_socket='define'
d_socklen_t='define'
d_sockpair='define'
d_socks5_init='undef'
d_sprintf_returns_strlen='define'
d_sqrtl='define'
d_srand48_r='define'
d_srandom_r='define'
d_sresgproto='define'
d_sresuproto='define'
d_statblks='define'
d_statfs_f_flags='define'
d_statfs_s='define'
d_static_inline='define'
d_statvfs='define'
d_stdio_cnt_lval='undef'
d_stdio_ptr_lval='undef'
d_stdio_ptr_lval_nochange_cnt='undef'
d_stdio_ptr_lval_sets_cnt='undef'
d_stdio_stream_array='undef'
d_stdiobase='undef'
d_stdstdio='undef'
d_strchr='define'
d_strcoll='define'
d_strctcpy='define'
d_strerrm='strerror(e)'
d_strerror='define'
d_strerror_r='define'
d_strftime='define'
d_strlcat='define'
d_strlcpy='define'
d_strtod='define'
d_strtol='define'
d_strtold='define'
d_strtoll='define'
d_strtoq='define'
d_strtoul='define'
d_strtoull='define'
d_strtouq='define'
d_strxfrm='define'
d_suidsafe='undef'
d_symlink='define'
d_syscall='define'
d_syscallproto='define'
d_sysconf='define'
d_sysernlst=''
d_syserrlst='undef'
d_system='define'
d_tcgetpgrp='define'
d_tcsetpgrp='define'
d_telldir='define'
d_telldirproto='define'
d_time='define'
d_timegm='define'
d_times='define'
d_tm_tm_gmtoff='define'
d_tm_tm_zone='define'
d_tmpnam_r='define'
d_truncate='define'
d_ttyname_r='define'
d_tzname='define'
d_u32align='define'
d_ualarm='define'
d_umask='define'
d_uname='define'
d_union_semun='undef'
d_unordered='undef'
d_unsetenv='define'
d_usleep='define'
d_usleepproto='define'
d_ustat='undef'
d_vendorarch='define'
d_vendorbin='define'
d_vendorlib='define'
d_vendorscript='define'
d_vfork='undef'
d_void_closedir='undef'
d_voidsig='define'
d_voidtty=''
d_volatile='define'
d_vprintf='define'
d_vsnprintf='define'
d_wait4='define'
d_waitpid='define'
d_wcstombs='define'
d_wctomb='define'
d_writev='define'
d_xenix='undef'
date='date'
db_hashtype='u_int32_t'
db_prefixtype='size_t'
db_version_major='4'
db_version_minor='8'
db_version_patch='30'
defvoidused='15'
direntrytype='struct dirent'
dlext='so'
dlsrc='dl_dlopen.xs'
doublesize='8'
drand01='drand48()'
drand48_r_proto='REENTRANT_PROTO_I_ST'
dtrace=''
dynamic_ext='B Compress/Raw/Bzip2 Compress/Raw/Zlib Cwd DB_File Data/Dumper Devel/PPPort Devel/Peek Digest/MD5 Digest/SHA Encode Fcntl File/Glob Filter/Util/Call Hash/Util Hash/Util/FieldHash I18N/Langinfo IO IPC/SysV List/Util MIME/Base64 Math/BigInt/FastCalc Opcode POSIX PerlIO/encoding PerlIO/mmap PerlIO/scalar PerlIO/via SDBM_File Socket Storable Sys/Hostname Sys/Syslog Text/Soundex Tie/Hash/NamedCapture Time/HiRes Time/Piece Unicode/Collate Unicode/Normalize XS/APItest XS/Typemap arybase attributes mro re threads threads/shared'
eagain='EAGAIN'
ebcdic='undef'
echo='echo'
egrep='egrep'
emacs=''
endgrent_r_proto='0'
endhostent_r_proto='0'
endnetent_r_proto='0'
endprotoent_r_proto='0'
endpwent_r_proto='0'
endservent_r_proto='0'
eunicefix=':'
exe_ext=''
expr='expr'
extensions='B Compress/Raw/Bzip2 Compress/Raw/Zlib Cwd DB_File Data/Dumper Devel/PPPort Devel/Peek Digest/MD5 Digest/SHA Encode Fcntl File/Glob Filter/Util/Call Hash/Util Hash/Util/FieldHash I18N/Langinfo IO IPC/SysV List/Util MIME/Base64 Math/BigInt/FastCalc Opcode POSIX PerlIO/encoding PerlIO/mmap PerlIO/scalar PerlIO/via SDBM_File Socket Storable Sys/Hostname Sys/Syslog Text/Soundex Tie/Hash/NamedCapture Time/HiRes Time/Piece Unicode/Collate Unicode/Normalize XS/APItest XS/Typemap arybase attributes mro re threads threads/shared Archive/Extract Archive/Tar Attribute/Handlers AutoLoader B/Debug B/Deparse B/Lint CGI CPAN CPAN/Meta CPAN/Meta/YAML CPANPLUS CPANPLUS/Dist/Build Carp Devel/SelfStubber Digest Dumpvalue Env Errno ExtUtils/CBuilder ExtUtils/Command ExtUtils/Constant ExtUtils/Install ExtUtils/MakeMaker ExtUtils/Manifest ExtUtils/ParseXS File/CheckTree File/Fetch File/Path File/Temp FileCache Filter/Simple Getopt/Long HTTP/Tiny I18N/Collate I18N/LangTags IO/Compress IO/Zlib IPC/Cmd IPC/Open3 JSON/PP Locale/Codes Locale/Maketext Locale/Maketext/Simple Log/Message Log/Message/Simple Math/BigInt Math/BigRat Math/Complex Memoize Module/Build Module/CoreList Module/Load Module/Load/Conditional Module/Loaded Module/Metadata Module/Pluggable NEXT Net/Ping Object/Accessor Package/Constants Params/Check Parse/CPAN/Meta Perl/OSType PerlIO/via/QuotedPrint Pod/Escapes Pod/Functions Pod/Html Pod/LaTeX Pod/Parser Pod/Perldoc Pod/Simple Safe Search/Dict SelfLoader Term/ANSIColor Term/Cap Term/Complete Term/ReadLine Term/UI Test Test/Harness Test/Simple Text/Abbrev Text/Balanced Text/ParseWords Text/Tabs Thread/Queue Thread/Semaphore Tie/File Tie/Memoize Tie/RefHash Time/Local Version/Requirements XSLoader autodie autouse base bignum constant encoding/warnings if lib libnet parent perlfaq podlators'
extern_C='extern'
extras=''
fflushNULL='define'
fflushall='undef'
find=''
firstmakefile='makefile'
flex=''
fpossize='16'
fpostype='fpos_t'
freetype='void'
from=':'
full_ar='/usr/bin/ar'
full_csh='csh'
full_sed='/bin/sed'
gccansipedantic=''
gccosandvers=''
gccversion='12.3.1 20230626 (Aurora OS gcc 12.3.1+git2-1.4.2.omp)'
getgrent_r_proto='REENTRANT_PROTO_I_SBWR'
getgrgid_r_proto='REENTRANT_PROTO_I_TSBWR'
getgrnam_r_proto='REENTRANT_PROTO_I_CSBWR'
gethostbyaddr_r_proto='REENTRANT_PROTO_I_TsISBWRE'
gethostbyname_r_proto='REENTRANT_PROTO_I_CSBWRE'
gethostent_r_proto='REENTRANT_PROTO_I_SBWRE'
getlogin_r_proto='REENTRANT_PROTO_I_BW'
getnetbyaddr_r_proto='REENTRANT_PROTO_I_uISBWRE'
getnetbyname_r_proto='REENTRANT_PROTO_I_CSBWRE'
getnetent_r_proto='REENTRANT_PROTO_I_SBWRE'
getprotobyname_r_proto='REENTRANT_PROTO_I_CSBWR'
getprotobynumber_r_proto='REENTRANT_PROTO_I_ISBWR'
getprotoent_r_proto='REENTRANT_PROTO_I_SBWR'
getpwent_r_proto='REENTRANT_PROTO_I_SBWR'
getpwnam_r_proto='REENTRANT_PROTO_I_CSBWR'
getpwuid_r_proto='REENTRANT_PROTO_I_TSBWR'
getservbyname_r_proto='REENTRANT_PROTO_I_CCSBWR'
getservbyport_r_proto='REENTRANT_PROTO_I_ICSBWR'
getservent_r_proto='REENTRANT_PROTO_I_SBWR'
getspnam_r_proto='REENTRANT_PROTO_I_CSBWR'
gidformat='"u"'
gidsign='1'
gidsize='4'
gidtype='gid_t'
glibpth='/usr/shlib  /lib /usr/lib /usr/lib/386 /lib/386 /usr/ccs/lib /usr/ucblib /usr/local/lib /lib64 /usr/lib64 /usr/local/lib64 '
gmake='gmake'
gmtime_r_proto='REENTRANT_PROTO_S_TS'
gnulibc_version='2.38'
grep='grep'
groupcat='cat /etc/group'
groupstype='gid_t'
gzip='gzip'
h_fcntl='false'
h_sysfile='true'
hint='recommended'
hostcat='cat /etc/hosts'
html1dir=' '
html1direxp=''
html3dir=' '
html3direxp=''
i16size='2'
i16type='short'
i32size='4'
i32type='int'
i64size='8'
i64type='long'
i8size='1'
i8type='signed char'
i_arpainet='define'
i_assert='define'
i_bsdioctl=''
i_crypt='define'
i_db='define'
i_dbm='undef'
i_dirent='define'
i_dld='undef'
i_dlfcn='define'
i_fcntl='undef'
i_float='define'
i_fp='undef'
i_fp_class='undef'
i_gdbm='undef'
i_gdbm_ndbm='undef'
i_gdbmndbm='undef'
i_grp='define'
i_ieeefp='undef'
i_inttypes='define'
i_langinfo='define'
i_libutil='undef'
i_limits='define'
i_locale='define'
i_machcthr='undef'
i_malloc='define'
i_mallocmalloc='undef'
i_math='define'
i_memory='undef'
i_mntent='define'
i_ndbm='undef'
i_netdb='define'
i_neterrno='undef'
i_netinettcp='define'
i_niin='define'
i_poll='define'
i_prot='undef'
i_pthread='define'
i_pwd='define'
i_rpcsvcdbm='undef'
i_sfio='undef'
i_sgtty='undef'
i_shadow='define'
i_socks='undef'
i_stdarg='define'
i_stdbool='define'
i_stddef='define'
i_stdlib='define'
i_string='define'
i_sunmath='undef'
i_sysaccess='undef'
i_sysdir='define'
i_sysfile='define'
i_sysfilio='undef'
i_sysin='undef'
i_sysioctl='define'
i_syslog='define'
i_sysmman='define'
i_sysmode='undef'
i_sysmount='define'
i_sysndir='undef'
i_sysparam='define'
i_syspoll='define'
i_sysresrc='define'
i_syssecrt='undef'
i_sysselct='define'
i_syssockio='undef'
i_sysstat='define'
i_sysstatfs='define'
i_sysstatvfs='define'
i_systime='define'
i_systimek='undef'
i_systimes='define'
i_systypes='define'
i_sysuio='define'
i_sysun='define'
i_sysutsname='define'
i_sysvfs='define'
i_syswait='define'
i_termio='undef'
i_termios='define'
i_time='define'
i_unistd='define'
i_ustat='undef'
i_utime='define'
i_values='define'
i_varargs='undef'
i_varhdr='stdarg.h'
i_vfork='undef'
ignore_versioned_solibs='y'
inc_version_list=' '
inc_version_list_init='0'
incpath=''
inews=''
initialinstalllocation='/usr/bin'
installarchlib='/usr/lib64/perl5'
installbin='/usr/bin'
installhtml1dir=''
installhtml3dir=''
installman1dir='/usr/share/man/man1'
installman3dir='/usr/share/man/man3'
installprefix='/usr'
installprefixexp='/usr'
installprivlib='/usr/share/perl5'
installscript='/usr/bin'
installsitearch='/usr/local/lib64/perl5'
installsitebin='/usr/local/bin'
installsitehtml1dir=''
installsitehtml3dir=''
installsitelib='/usr/local/share/perl5'
installsiteman1dir='/usr/local/share/man/man1'
installsiteman3dir='/usr/local/share/man/man3'
installsitescript='/usr/local/bin'
installstyle='lib64/perl5'
installusrbinperl='undef'
installvendorarch='/usr/lib64/perl5/vendor_perl'
installvendorbin='/usr/bin'
installvendorhtml1dir=''
installvendorhtml3dir=''
installvendorlib='/usr/share/perl5/vendor_perl'
installvendorman1dir='/usr/share/man/man1'
installvendorman3dir='/usr/share/man/man3'
installvendorscript='/usr/bin'
intsize='4'
issymlink='test -h'
ivdformat='"ld"'
ivsize='8'
ivtype='long'
known_extensions='B Compress/Raw/Bzip2 Compress/Raw/Zlib Cwd DB_File Data/Dumper Devel/PPPort Devel/Peek Digest/MD5 Digest/SHA Encode Fcntl File/Glob Filter/Util/Call GDBM_File Hash/Util Hash/Util/FieldHash I18N/Langinfo IO IPC/SysV List/Util MIME/Base64 Math/BigInt/FastCalc NDBM_File ODBM_File Opcode POSIX PerlIO/encoding PerlIO/mmap PerlIO/scalar PerlIO/via SDBM_File Socket Storable Sys/Hostname Sys/Syslog Text/Soundex Tie/Hash/NamedCapture Time/HiRes Time/Piece Unicode/Collate Unicode/Normalize VMS/DCLsym VMS/Stdio Win32 Win32API/File Win32CORE XS/APItest XS/Typemap arybase attributes mro re threads threads/shared '
ksh=''
ld='gcc'
ld_can_script='define'
lddlflags='-shared -g -pipe -fexceptions --param=ssp-buffer-size=4 -O2 -Wp,-U_FORTIFY_SOURCE,-D_FORTIFY_SOURCE=2 -specs=/usr/lib/rpm/aurora/pie-pic-cc1 -fstack-protector-strong -Wall -Wformat -Wformat-security -m64 -mtune=generic '
ldflags='-Wl,--as-needed -specs=/usr/lib/rpm/aurora/pie-pic-ld -Wl,-z,relro,-z,now  -fstack-protector'
ldflags_uselargefiles=''
ldlibpthname='LD_LIBRARY_PATH'
less='less'
lib_ext='.a'
libc=''
libdb_needs_pthread='N'
libperl='libperl.so'
libpth='/usr/local/lib64 /lib /usr/lib /lib64 /usr/lib64'
libs='-lresolv -ldb -ldl -lm -lcrypt -lutil -lpthread -lc'
libsdirs=' /lib /usr/lib'
libsfiles=' libresolv.so libdb.so libdl.a libm.so libcrypt.so libutil.a libpthread.a libc.so'
libsfound=' /lib/libresolv.so /usr/lib/libdb.so /lib/libdl.a /lib/libm.so /usr/lib/libcrypt.so /lib/libutil.a /lib/libpthread.a /lib/libc.so'
libspath=' /usr/local/lib64 /lib /usr/lib /lib64 /usr/lib64'
libswanted='sfio socket resolv inet nsl nm ndbm gdbm dbm db malloc dl dld ld sun m crypt sec util pthread c cposix posix ucb BSD gdbm_compat'
libswanted_uselargefiles=''
line=''
lint=''
lkflags=''
ln='ln'
lns='/bin/ln -s'
localtime_r_proto='REENTRANT_PROTO_S_TS'
locincpth='/usr/local/include /opt/local/include /usr/gnu/include /opt/gnu/include /usr/GNU/include /opt/GNU/include'
loclibpth='/usr/local/lib /opt/local/lib /usr/gnu/lib /opt/gnu/lib /usr/GNU/lib /opt/GNU/lib'
longdblsize='16'
longlongsize='8'
longsize='8'
lp=''
lpr=''
ls='ls'
lseeksize='8'
lseektype='off_t'
mad='undef'
madlyh=''
madlyobj=''
madlysrc=''
mail=''
mailx=''
make='make'
make_set_make='#'
mallocobj=''
mallocsrc=''
malloctype='void *'
man1dir='/usr/share/man/man1'
man1direxp='/usr/share/man/man1'
man1ext='1'
man3dir='/usr/share/man/man3'
man3direxp='/usr/share/man/man3'
man3ext='3pm'
mips_type=''
mistrustnm=''
mkdir='mkdir'
mmaptype='void *'
modetype='mode_t'
more='more'
multiarch='undef'
mv=''
myarchname='x86_64-linux'
mydomain='.localdomain'
myhostname='localhost'
n='-n'
need_va_copy='define'
netdb_hlen_type='size_t'
netdb_host_type='char *'
netdb_name_type='const char *'
netdb_net_type='in_addr_t'
nm='nm'
nm_opt=''
nm_so_opt='--dynamic'
nonxs_ext='Archive/Extract Archive/Tar Attribute/Handlers AutoLoader B/Debug B/Deparse B/Lint CGI CPAN CPAN/Meta CPAN/Meta/YAML CPANPLUS CPANPLUS/Dist/Build Carp Devel/SelfStubber Digest Dumpvalue Env Errno ExtUtils/CBuilder ExtUtils/Command ExtUtils/Constant ExtUtils/Install ExtUtils/MakeMaker ExtUtils/Manifest ExtUtils/ParseXS File/CheckTree File/Fetch File/Path File/Temp FileCache Filter/Simple Getopt/Long HTTP/Tiny I18N/Collate I18N/LangTags IO/Compress IO/Zlib IPC/Cmd IPC/Open3 JSON/PP Locale/Codes Locale/Maketext Locale/Maketext/Simple Log/Message Log/Message/Simple Math/BigInt Math/BigRat Math/Complex Memoize Module/Build Module/CoreList Module/Load Module/Load/Conditional Module/Loaded Module/Metadata Module/Pluggable NEXT Net/Ping Object/Accessor Package/Constants Params/Check Parse/CPAN/Meta Perl/OSType PerlIO/via/QuotedPrint Pod/Escapes Pod/Functions Pod/Html Pod/LaTeX Pod/Parser Pod/Perldoc Pod/Simple Safe Search/Dict SelfLoader Term/ANSIColor Term/Cap Term/Complete Term/ReadLine Term/UI Test Test/Harness Test/Simple Text/Abbrev Text/Balanced Text/ParseWords Text/Tabs Thread/Queue Thread/Semaphore Tie/File Tie/Memoize Tie/RefHash Time/Local Version/Requirements XSLoader autodie autouse base bignum constant encoding/warnings if lib libnet parent perlfaq podlators'
nroff='nroff'
nvEUformat='"E"'
nvFUformat='"F"'
nvGUformat='"G"'
nv_overflows_integers_at='256.0*256.0*256.0*256.0*256.0*256.0*2.0*2.0*2.0*2.0*2.0'
nv_preserves_uv_bits='53'
nveformat='"e"'
nvfformat='"f"'
nvgformat='"g"'
nvsize='8'
nvtype='double'
o_nonblock='O_NONBLOCK'
obj_ext='.o'
old_pthread_create_joinable=''
optimize='-g -pipe -fexceptions --param=ssp-buffer-size=4 -O2 -Wp,-U_FORTIFY_SOURCE,-D_FORTIFY_SOURCE=2 -specs=/usr/lib/rpm/aurora/pie-pic-cc1 -fstack-protector-strong -Wall -Wformat -Wformat-security -m64 -mtune=generic'
orderlib='false'
osname='linux'
osvers='5.14.21-150400.24.60-default'
otherlibdirs=' '
package='perl5'
pager='/usr/bin/less -isr'
passcat='cat /etc/passwd'
patchlevel='16'
path_sep=':'
perl5='/usr/bin/perl'
perl='perl'
perl_patchlevel=''
perl_static_inline='static __inline__'
perladmin='root@localhost'
perllibs='-lresolv -ldl -lm -lcrypt -lutil -lpthread -lc'
perlpath='/usr/bin/perl'
pg='pg'
phostname=''
pidtype='pid_t'
plibpth='/lib/x86_64-meego-linux-gnu/12.3.1 /lib/../lib64 /usr/lib/x86_64-meego-linux-gnu/12.3.1 /usr/lib/../lib64 /lib /usr/lib'
pmake=''
pr=''
prefix='/usr'
prefixexp='/usr'
privlib='/usr/share/perl5'
privlibexp='/usr/share/perl5'
procselfexe='"/proc/self/exe"'
prototype='define'
ptrsize='8'
quadkind='2'
quadtype='long'
randbits='48'
randfunc='drand48'
random_r_proto='REENTRANT_PROTO_I_St'
randseedtype='long'
ranlib=':'
rd_nodata='-1'
readdir64_r_proto='REENTRANT_PROTO_I_TSR'
readdir_r_proto='REENTRANT_PROTO_I_TSR'
revision='5'
rm='rm'
rm_try='/bin/rm -f try try a.out .out try.[cho] try..o core core.try* try.core*'
rmail=''
run=''
runnm='false'
sGMTIME_max='67768036191676799'
sGMTIME_min='-62167219200'
sLOCALTIME_max='67768036191676799'
sLOCALTIME_min='-62167219200'
sPRIEUldbl='"LE"'
sPRIFUldbl='"LF"'
sPRIGUldbl='"LG"'
sPRIXU64='"lX"'
sPRId64='"ld"'
sPRIeldbl='"Le"'
sPRIfldbl='"Lf"'
sPRIgldbl='"Lg"'
sPRIi64='"li"'
sPRIo64='"lo"'
sPRIu64='"lu"'
sPRIx64='"lx"'
sSCNfldbl='"Lf"'
sched_yield='sched_yield()'
scriptdir='/usr/bin'
scriptdirexp='/usr/bin'
sed='sed'
seedfunc='srand48'
selectminbits='64'
selecttype='fd_set *'
sendmail=''
setgrent_r_proto='0'
sethostent_r_proto='0'
setlocale_r_proto='0'
setnetent_r_proto='0'
setprotoent_r_proto='0'
setpwent_r_proto='0'
setservent_r_proto='0'
sh='/bin/sh'
shar=''
sharpbang='#!'
shmattype='void *'
shortsize='2'
shrpenv=''
shsharp='true'
sig_count='65'
sig_name='ZERO HUP INT QUIT ILL TRAP ABRT BUS FPE KILL USR1 SEGV USR2 PIPE ALRM TERM STKFLT CHLD CONT STOP TSTP TTIN TTOU URG XCPU XFSZ VTALRM PROF WINCH IO PWR SYS NUM32 NUM33 RTMIN NUM35 NUM36 NUM37 NUM38 NUM39 NUM40 NUM41 NUM42 NUM43 NUM44 NUM45 NUM46 NUM47 NUM48 NUM49 NUM50 NUM51 NUM52 NUM53 NUM54 NUM55 NUM56 NUM57 NUM58 NUM59 NUM60 NUM61 NUM62 NUM63 RTMAX IOT CLD POLL '
sig_name_init='"ZERO", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "BUS", "FPE", "KILL", "USR1", "SEGV", "USR2", "PIPE", "ALRM", "TERM", "STKFLT", "CHLD", "CONT", "STOP", "TSTP", "TTIN", "TTOU", "URG", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "IO", "PWR", "SYS", "NUM32", "NUM33", "RTMIN", "NUM35", "NUM36", "NUM37", "NUM38", "NUM39", "NUM40", "NUM41", "NUM42", "NUM43", "NUM44", "NUM45", "NUM46", "NUM47", "NUM48", "NUM49", "NUM50", "NUM51", "NUM52", "NUM53", "NUM54", "NUM55", "NUM56", "NUM57", "NUM58", "NUM59", "NUM60", "NUM61", "NUM62", "NUM63", "RTMAX", "IOT", "CLD", "POLL", 0'
sig_num='0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 6 17 29 '
sig_num_init='0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 6, 17, 29, 0'
sig_size='68'
signal_t='void'
sitearch='/usr/local/lib64/perl5'
sitearchexp='/usr/local/lib64/perl5'
sitebin='/usr/local/bin'
sitebinexp='/usr/local/bin'
sitehtml1dir=''
sitehtml1direxp=''
sitehtml3dir=''
sitehtml3direxp=''
sitelib='/usr/local/share/perl5'
sitelib_stem='/usr/local/share/perl5'
sitelibexp='/usr/local/share/perl5'
siteman1dir='/usr/local/share/man/man1'
siteman1direxp='/usr/local/share/man/man1'
siteman3dir='/usr/local/share/man/man3'
siteman3direxp='/usr/local/share/man/man3'
siteprefix='/usr/local'
siteprefixexp='/usr/local'
sitescript='/usr/local/bin'
sitescriptexp='/usr/local/bin'
sizesize='8'
sizetype='size_t'
sleep=''
smail=''
so='so'
sockethdr=''
socketlib=''
socksizetype='socklen_t'
sort='sort'
spackage='Perl5'
spitshell='cat'
srand48_r_proto='REENTRANT_PROTO_I_LS'
srandom_r_proto='REENTRANT_PROTO_I_TS'
src='.'
ssizetype='ssize_t'
st_ino_sign='1'
st_ino_size='8'
startperl='#!/usr/bin/perl'
startsh='#!/bin/sh'
static_ext=' '
stdchar='char'
stdio_base='((fp)->_base)'
stdio_bufsiz='((fp)->_cnt + (fp)->_ptr - (fp)->_base)'
stdio_cnt='((fp)->_cnt)'
stdio_filbuf=''
stdio_ptr='((fp)->_ptr)'
stdio_stream_array=''
strerror_r_proto='REENTRANT_PROTO_B_IBW'
strings='/usr/include/string.h'
submit=''
subversion='3'
sysman='/usr/share/man/man1'
tail=''
tar=''
targetarch=''
tbl=''
tee=''
test='test'
timeincl='/usr/include/sys/time.h /usr/include/time.h '
timetype='time_t'
tmpnam_r_proto='REENTRANT_PROTO_B_B'
to=':'
touch='touch'
tr='tr'
trnl='\n'
troff=''
ttyname_r_proto='REENTRANT_PROTO_I_IBW'
u16size='2'
u16type='unsigned short'
u32size='4'
u32type='unsigned int'
u64size='8'
u64type='unsigned long'
u8size='1'
u8type='unsigned char'
uidformat='"u"'
uidsign='1'
uidsize='4'
uidtype='uid_t'
uname='uname'
uniq='uniq'
uquadtype='unsigned long'
use5005threads='undef'
use64bitall='define'
use64bitint='define'
usecrosscompile='undef'
usedevel='undef'
usedl='define'
usedtrace='undef'
usefaststdio='undef'
useithreads='define'
usekernprocpathname='undef'
uselargefiles='define'
uselongdouble='undef'
usemallocwrap='define'
usemorebits='undef'
usemultiplicity='define'
usemymalloc='n'
usenm='false'
usensgetexecutablepath='undef'
useopcode='true'
useperlio='define'
useposix='true'
usereentrant='undef'
userelocatableinc='undef'
usesfio='false'
useshrplib='true'
usesitecustomize='define'
usesocks='undef'
usethreads='define'
usevendorprefix='define'
usevfork='false'
usrinc='/usr/include'
uuname=''
uvXUformat='"lX"'
uvoformat='"lo"'
uvsize='8'
uvtype='unsigned long'
uvuformat='"lu"'
uvxformat='"lx"'
vaproto='define'
vendorarch='/usr/lib64/perl5/vendor_perl'
vendorarchexp='/usr/lib64/perl5/vendor_perl'
vendorbin='/usr/bin'
vendorbinexp='/usr/bin'
vendorhtml1dir=' '
vendorhtml1direxp=''
vendorhtml3dir=' '
vendorhtml3direxp=''
vendorlib='/usr/share/perl5/vendor_perl'
vendorlib_stem='/usr/share/perl5/vendor_perl'
vendorlibexp='/usr/share/perl5/vendor_perl'
vendorman1dir='/usr/share/man/man1'
vendorman1direxp='/usr/share/man/man1'
vendorman3dir='/usr/share/man/man3'
vendorman3direxp='/usr/share/man/man3'
vendorprefix='/usr'
vendorprefixexp='/usr'
vendorscript='/usr/bin'
vendorscriptexp='/usr/bin'
version='5.16.3'
version_patchlevel_string='version 16 subversion 3'
versiononly='undef'
vi=''
voidflags='15'
xlibpth='/usr/lib/386 /lib/386'
yacc='yacc'
yaccflags=''
zcat=''
zip='zip'
!END!

my $i = ord(8);
foreach my $c (7,6,5,4,3,2,1) { $i <<= 8; $i |= ord($c); }
our $byteorder = join('', unpack('aaaaaaaa', pack('L!', $i)));
s/(byteorder=)(['"]).*?\2/$1$2$Config::byteorder$2/m;

my $config_sh_len = length $_;

our $Config_SH_expanded = "\n$_" . << 'EOVIRTUAL';
ccflags_nolargefiles='-D_REENTRANT -D_GNU_SOURCE -g -pipe -fexceptions --param=ssp-buffer-size=4 -O2 -Wp,-U_FORTIFY_SOURCE,-D_FORTIFY_SOURCE=2 -specs=/usr/lib/rpm/aurora/pie-pic-cc1 -fstack-protector-strong -Wall -Wformat -Wformat-security -m64 -mtune=generic -fpcc-struct-return -I/usr/local/include '
ldflags_nolargefiles='-Wl,--as-needed -specs=/usr/lib/rpm/aurora/pie-pic-ld -Wl,-z,relro,-z,now  -fstack-protector'
libs_nolargefiles='-lresolv -ldb -ldl -lm -lcrypt -lutil -lpthread -lc'
libswanted_nolargefiles='sfio socket resolv inet nsl nm ndbm gdbm dbm db malloc dl dld ld sun m crypt sec util pthread c cposix posix ucb BSD gdbm_compat'
EOVIRTUAL
eval {
	# do not have hairy conniptions if this isnt available
	require 'Config_git.pl';
	$Config_SH_expanded .= $Config::Git_Data;
	1;
} or warn "Warning: failed to load Config_git.pl, something strange about this perl...\n";

# Search for it in the big string
sub fetch_string {
    my($self, $key) = @_;

    return undef unless $Config_SH_expanded =~ /\n$key=\'(.*?)\'\n/s;
    # So we can say "if $Config{'foo'}".
    $self->{$key} = $1 eq 'undef' ? undef : $1;
}

my $prevpos = 0;

sub FIRSTKEY {
    $prevpos = 0;
    substr($Config_SH_expanded, 1, index($Config_SH_expanded, '=') - 1 );
}

sub NEXTKEY {
    my $pos = index($Config_SH_expanded, qq('\n), $prevpos) + 2;
    my $len = index($Config_SH_expanded, "=", $pos) - $pos;
    $prevpos = $pos;
    $len > 0 ? substr($Config_SH_expanded, $pos, $len) : undef;
}

sub EXISTS {
    return 1 if exists($_[0]->{$_[1]});

    return(index($Config_SH_expanded, "\n$_[1]='") != -1
          );
}

sub STORE  { die "\%Config::Config is read-only\n" }
*DELETE = *CLEAR = \*STORE; # Typeglob aliasing uses less space

sub config_sh {
    substr $Config_SH_expanded, 1, $config_sh_len;
}

sub config_re {
    my $re = shift;
    return map { chomp; $_ } grep eval{ /^(?:$re)=/ }, split /^/,
    $Config_SH_expanded;
}

sub config_vars {
    # implements -V:cfgvar option (see perlrun -V:)
    foreach (@_) {
	# find optional leading, trailing colons; and query-spec
	my ($notag,$qry,$lncont) = m/^(:)?(.*?)(:)?$/;	# flags fore and aft, 
	# map colon-flags to print decorations
	my $prfx = $notag ? '': "$qry=";		# tag-prefix for print
	my $lnend = $lncont ? ' ' : ";\n";		# line ending for print

	# all config-vars are by definition \w only, any \W means regex
	if ($qry =~ /\W/) {
	    my @matches = config_re($qry);
	    print map "$_$lnend", @matches ? @matches : "$qry: not found"		if !$notag;
	    print map { s/\w+=//; "$_$lnend" } @matches ? @matches : "$qry: not found"	if  $notag;
	} else {
	    my $v = (exists $Config::Config{$qry}) ? $Config::Config{$qry}
						   : 'UNKNOWN';
	    $v = 'undef' unless defined $v;
	    print "${prfx}'${v}'$lnend";
	}
    }
}

# Called by the real AUTOLOAD
sub launcher {
    undef &AUTOLOAD;
    goto \&$Config::AUTOLOAD;
}

1;
