/*
 * Copyright (c) 2023 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_BLUETOOTH
#define SAILFISH_MDM_BLUETOOTH

#include <QObject>
#include <QString>
#include <QStringList>

namespace Sailfish {
namespace Mdm {

class BluetoothPrivate;

class Q_DECL_EXPORT Bluetooth : public QObject
{
    Q_OBJECT

public:
    Bluetooth(QObject *parent = 0);
    ~Bluetooth() = default;

    bool isVisible() const;
    void setVisible(bool discoverable);
    QString name() const;
    void setName(const QString &name);
    void startDiscovery();
    void stopDiscovery();
    bool isDiscovering() const;

signals:
    void bluetoothReady();
    void bluetoothError();
    void deviceAdded(const QString &address);
    void deviceRemoved(const QString &address);

private:
    BluetoothPrivate *d_ptr;
    Q_DISABLE_COPY(Bluetooth)
    Q_DECLARE_PRIVATE(Bluetooth)
};

} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_BLUETOOTH
