/****************************************************************************************
**
** Copyright (c) 2023 Open Mobile Platform LLC.
** Copyright (C) 2014 Jolla Ltd.
** All rights reserved.
**
** This file is part of Sailfish Silica UI component package.
**
** You may use this file under the terms of BSD license as follows:
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are met:
**     * Redistributions of source code must retain the above copyright
**       notice, this list of conditions and the following disclaimer.
**     * Redistributions in binary form must reproduce the above copyright
**       notice, this list of conditions and the following disclaimer in the
**       documentation and/or other materials provided with the distribution.
**     * Neither the name of the Jolla Ltd nor the
**       names of its contributors may be used to endorse or promote products
**       derived from this software without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
** DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
** (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
** ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0

Loader {
    id: root

    property QtObject _counters

    active: _counters && _counters.hints_enabled.value && _counters.coordination_state.value === 1
    anchors.centerIn: parent
    width: window.screenRotation === 0 ? (pageStack.verticalOrientation ? parent.width : parent.height)
                                       : (pageStack.verticalOrientation ? parent.height : parent.width)
    height: width === parent.width ? parent.height : parent.width
    source: "ReturnToHomeHint.qml"

    Component.onCompleted: {
        // Avoid hard dependency to Configuration module
        _counters = Qt.createQmlObject("import Nemo.Configuration 1.0;
                                        import QtQuick 2.0;

                                        QtObject {
                                            property ConfigurationValue coordination_state: ConfigurationValue {
                                                key: '/desktop/sailfish/hints/coordination_state'
                                                defaultValue: 3 // no system hints for existing users
                                            }
                                            property ConfigurationValue hints_enabled: ConfigurationValue {
                                                key: '/desktop/sailfish/silica/hints_enabled'
                                                defaultValue: true
                                            }
                                        }", root, 'ConfigurationValues')
    }
}
