/****************************************************************************
**
** Copyright (c) 2022 Open Mobile Platform LLC.
** Copyright (C) 2013-2016 Jolla Ltd.
** Contact: Raine Mäkeläinen <raine.makelainen@jollamobile.com>
**
****************************************************************************/

import QtQuick 2.0
import QtDocGallery 5.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Sailfish.Gallery 1.0
import Sailfish.Pickers 1.0
import "private"

PickerPage {
    id: videoPicker

    //% "Select video"
    title: qsTrId("components_pickers-he-select_video")

    orientationTransitions: Private.PageOrientationTransition {
        fadeTarget: _background ? gridView : __silica_applicationwindow_instance.contentItem
        targetPage: videoPicker
    }

    VideoModel {
        id: videoModel
    }

    PickerGridView {
        id: gridView

        title: videoPicker.title
        headerPlaceholderText: qsTrId("components_pickers-ph-search_videos")
        emptyPlaceholderText: qsTrId("components_pickers-ph-empty_folder")
        itemModel: videoModel
        model: videoModel.model
        selectionEnabled: false
        isDialog: false
    }
}
